<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ValIncompatibiliteHla
 *
 * @ORM\Table(name="val_incompatibilite_hla")
 * @ORM\Entity
 */
class ValIncompatibiliteHla
{
    /**
     * @var string
     *
     * @ORM\Column(name="vih_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $vihCode;

    /**
     * @var string
     *
     * @ORM\Column(name="vih_libelle", type="string", length=50, nullable=false)
     */
    private $vihLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="vih_ordre", type="decimal", precision=1, scale=0, nullable=false)
     */
    private $vihOrdre;



    /**
     * Get vihCode.
     *
     * @return string
     */
    public function getVihCode()
    {
        return $this->vihCode;
    }

    /**
     * Set vihLibelle.
     *
     * @param string $vihLibelle
     *
     * @return ValIncompatibiliteHla
     */
    public function setVihLibelle($vihLibelle)
    {
        $this->vihLibelle = $vihLibelle;

        return $this;
    }

    /**
     * Get vihLibelle.
     *
     * @return string
     */
    public function getVihLibelle()
    {
        return $this->vihLibelle;
    }

    /**
     * Set vihOrdre.
     *
     * @param string $vihOrdre
     *
     * @return ValIncompatibiliteHla
     */
    public function setVihOrdre($vihOrdre)
    {
        $this->vihOrdre = $vihOrdre;

        return $this;
    }

    /**
     * Get vihOrdre.
     *
     * @return string
     */
    public function getVihOrdre()
    {
        return $this->vihOrdre;
    }
}
