<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ValeurStatutViro
 *
 * @ORM\Table(name="valeur_statut_viro", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_hla_vih", columns={"gre_code", "svi_code", "vir_code"})}, indexes={@ORM\Index(name="fk_valeur_statut_viro_statut_viro", columns={"svi_code"}), @ORM\Index(name="fk_valeur_statut_viro_virus", columns={"vir_code"}), @ORM\Index(name="IDX_E78B94FE70D09EBE", columns={"gre_code"})})
 * @ORM\Entity
 */
class ValeurStatutViro
{
    /**
     * @var int
     *
     * @ORM\Column(name="vsr_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $vsrCode;

    /**
     * @var \RAN\Entity\Virus
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Virus")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="vir_code", referencedColumnName="vir_code")
     * })
     */
    private $virCode;

    /**
     * @var \RAN\Entity\StatutVirologique
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\StatutVirologique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="svi_code", referencedColumnName="svi_code")
     * })
     */
    private $sviCode;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;



    /**
     * Get vsrCode.
     *
     * @return int
     */
    public function getVsrCode()
    {
        return $this->vsrCode;
    }

    /**
     * Set virCode.
     *
     * @param \RAN\Entity\Virus|null $virCode
     *
     * @return ValeurStatutViro
     */
    public function setVirCode(\RAN\Entity\Virus $virCode = null)
    {
        $this->virCode = $virCode;

        return $this;
    }

    /**
     * Get virCode.
     *
     * @return \RAN\Entity\Virus|null
     */
    public function getVirCode()
    {
        return $this->virCode;
    }

    /**
     * Set sviCode.
     *
     * @param \RAN\Entity\StatutVirologique|null $sviCode
     *
     * @return ValeurStatutViro
     */
    public function setSviCode(\RAN\Entity\StatutVirologique $sviCode = null)
    {
        $this->sviCode = $sviCode;

        return $this;
    }

    /**
     * Get sviCode.
     *
     * @return \RAN\Entity\StatutVirologique|null
     */
    public function getSviCode()
    {
        return $this->sviCode;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return ValeurStatutViro
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }
}
