<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Virus
 *
 * @ORM\Table(name="virus")
 * @ORM\Entity
 */
class Virus
{
    /**
     * @var string
     *
     * @ORM\Column(name="vir_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $virCode;

    /**
     * @var string
     *
     * @ORM\Column(name="vir_libelle", type="string", length=20, nullable=false)
     */
    private $virLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="vir_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $virOrdre;



    /**
     * Get virCode.
     *
     * @return string
     */
    public function getVirCode()
    {
        return $this->virCode;
    }

    /**
     * Set virLibelle.
     *
     * @param string $virLibelle
     *
     * @return Virus
     */
    public function setVirLibelle($virLibelle)
    {
        $this->virLibelle = $virLibelle;

        return $this;
    }

    /**
     * Get virLibelle.
     *
     * @return string
     */
    public function getVirLibelle()
    {
        return $this->virLibelle;
    }

    /**
     * Set virOrdre.
     *
     * @param string $virOrdre
     *
     * @return Virus
     */
    public function setVirOrdre($virOrdre)
    {
        $this->virOrdre = $virOrdre;

        return $this;
    }

    /**
     * Get virOrdre.
     *
     * @return string
     */
    public function getVirOrdre()
    {
        return $this->virOrdre;
    }
}
