<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * VoieAbord
 *
 * @ORM\Table(name="voie_abord")
 * @ORM\Entity
 */
class VoieAbord
{
    /**
     * @var string
     *
     * @ORM\Column(name="voa_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $voaCode;

    /**
     * @var string
     *
     * @ORM\Column(name="voa_libelle", type="string", length=50, nullable=false)
     */
    private $voaLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="voa_ordre", type="decimal", precision=1, scale=0, nullable=false)
     */
    private $voaOrdre;



    /**
     * Get voaCode.
     *
     * @return string
     */
    public function getVoaCode()
    {
        return $this->voaCode;
    }

    /**
     * Set voaLibelle.
     *
     * @param string $voaLibelle
     *
     * @return VoieAbord
     */
    public function setVoaLibelle($voaLibelle)
    {
        $this->voaLibelle = $voaLibelle;

        return $this;
    }

    /**
     * Get voaLibelle.
     *
     * @return string
     */
    public function getVoaLibelle()
    {
        return $this->voaLibelle;
    }

    /**
     * Set voaOrdre.
     *
     * @param string $voaOrdre
     *
     * @return VoieAbord
     */
    public function setVoaOrdre($voaOrdre)
    {
        $this->voaOrdre = $voaOrdre;

        return $this;
    }

    /**
     * Get voaOrdre.
     *
     * @return string
     */
    public function getVoaOrdre()
    {
        return $this->voaOrdre;
    }
}
