<?php
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Mapping\Entity;

// #########################################################################//
// # Useful for data base
// #
// # Author: CFlorin (E-mail: colotin_f@yahoo.com)
// # Date: 11.01.2008
// #########################################################################//

/**
 * Sql Delete Row(s)
 *
 * @param: $tableName = table name | $idName = id name, $idValue = idValue
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlDel($tableName, $idName, $idValue)
{
    global $dbi;

    $q = "DELETE FROM $tableName WHERE $idName = '$idValue'";
    $dbi->execute($q);
}

/**
 * Empty a table
 *
 * @param: $tableName = table name
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlEmptyTable($tableName)
{
    global $dbi;

    $q = "DELETE FROM $tableName";
    $dbi->execute($q);
}

/**
 * Sql switch filed value 0->1 or 1->0
 *
 * @param: $table = table name | $fieldSwitch = name of swich filed | $idName = id name | $idValue = id value
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlFieldSwitch($tableName, $fieldSwitch, $idName, $idValue)
{
    global $dbi;

    $q = "UPDATE $tableName SET $fieldSwitch=($fieldSwitch+1)%2 WHERE $idName='$idValue'";
    $dbi->execute($q);
}

/**
 * Sql get field content
 *
 * @param: $table = table name | $fieldname = name of filed | $idName = id name | $idValue = id value
 * @access: public
 * @return: field name
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.08.2008 (dd.mm.YYYY)
 */
function _sqlGetFieldContent($tableName, $fieldName, $idName, $idValue, $idName2 = '', $idValue2 = '')
{
    global $dbi;

    $sqlWhere = "";
    if ($idName2 != "")
        $sqlWhere = " AND $idName2='$idValue2' ";

    $q = "SELECT $fieldName FROM $tableName WHERE $idName='$idValue' $sqlWhere ORDER BY $fieldName LIMIT 0,1";
    $dbi->query($q);
    if ($rec = $dbi->getRow(false, true))
        return $rec[0];
    else
        return false;
}

/**
 * Sql Get Table Content
 *
 * @param: $tableName = table name | $idName = id name | $fieldName = name of filed | $fieldOrder = name of filed for order | $outType = output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlGetRowContent($tableName, $idName, $idValue, $idName2 = '', $idValue2 = '')
{
    global $dbi;

    $sqlWhere = '';
    if ($idName2 != '')
        $sqlWhere = " AND $idName2='$idValue2' ";

    $q = "SELECT * FROM $tableName WHERE $idName = '$idValue' $sqlWhere LIMIT 0,1";
    $dbi->query($q);
    if ($rec = $dbi->getRow())
        return $rec;
    else
        return false;
}

/**
 * Sql Get Table Content
 *
 * @param: $tableName = table name | $idName = id name | $fieldName = name of filed | $fieldOrder = name of filed for order | $outType = output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlGetTableContent($tableName, $idName, $fieldName, $fieldOrder = '', $outType = 0)
{
    global $dbi;

    $ret = array();

    if ($outType == 2)
        $sqSelect = "*";
    else
        $sqSelect = "$idName, $fieldName";

    if ('' == $fieldOrder && $fieldName != '')
        $fieldOrder = $fieldName;
    if ($fieldOrder != '') {
        if ($fieldOrder != $fieldName && $fieldName != '')
            $sqlOrder = "ORDER BY $fieldOrder, $fieldName";
        else
            $sqlOrder = "ORDER BY $fieldOrder";
    }

    $q = "SELECT $sqSelect FROM $tableName $sqlOrder";
    $dbi->query($q);
    if (1 == $outType || 2 == $outType) {

        while ($ret[] = $dbi->getRow());
        unset($ret[count($ret) - 1]);
    } else {
        while ($rec = $dbi->getRow(false, true)) {
            $ret[0][] = $rec[0];
            $ret[1][] = $rec[1];
        }
    }

    return $ret;
}

/**
 * Sql Get Table Content Filtered
 *
 * @param: $tableName = table name | $idName = id name | $fieldName = name of filed | $filterName = name of filter | $filterValue = value of filter | $fieldOrder = name of filed for order | $outType = output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlGetTableContentFiltered($tableName, $idName, $fieldName, $filterName, $filterValue, $fieldOrder = '', $outType = 0)
{
    global $dbi;

    $ret = array();

    if ($outType == 2)
        $sqSelect = "*";
    else
        $sqSelect = "$idName, $fieldName";

    if ('' == $fieldOrder && $fieldName != '')
        $fieldOrder = $fieldName;
    if ($fieldOrder != '') {
        if ($fieldOrder != $fieldName && $fieldName != '')
            $sqlOrder = "ORDER BY $fieldOrder, $fieldName";
        else
            $sqlOrder = "ORDER BY $fieldOrder";
    }

    $q = "SELECT $sqSelect FROM $tableName WHERE $filterName = '$filterValue' $sqlOrder";
    $dbi->query($q);

    if (1 == $outType || 2 == $outType) {
        while ($ret[] = $dbi->getRow());
        unset($ret[count($ret) - 1]);
    } else {
        while ($rec = $dbi->getRow(false, true)) {
            $ret[0][] = $rec[0];
            $ret[1][] = $rec[1];
        }
    }

    return $ret;
}

/**
 * Sql Get Table No Rows
 *
 * @param: $tableName = table name
 * @access: public
 * @return: no rows
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlGetTableNoRows($tableName, $filterName = '', $filterValue = '')
{
    global $dbi;

    $sqlWhere = "";
    if ($filterName != '')
        $sqlWhere = " WHERE {$filterName} = '{$filterValue}' ";

    $q = "SELECT count(*) FROM {$tableName} {$sqlWhere}";
    $res_idx = $dbi->query($q);
    if ($rec = $dbi->getRow($res_idx, true))
        return $rec[0];
    else
        return 0;
}

/**
 * Sql Escape Value
 *
 * @param: $value = inser or update
 * @access: public
 * @return: value
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
 */
function _sqlEscValue($value, $trim = 0)
{
    if (1 == $trim)
        $value = trim($value);
    $value = mysql_escape_string(stripslashes($value));

    return $value;
}

/**
 * Check Field Exists Duplicate
 *
 * @access: public
 * @return: bool
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlCheckFieldExistsDuplicate($tableName, $fieldName, $fieldValue, $idName, $idValue = '')
{
    global $dbi;

    $fieldValue = _sqlEscValue($fieldValue);

    if ($idName == '') {
        $q = "SELECT $fieldName FROM $tableName WHERE $fieldName = '$fieldValue' LIMIT 0,1";
        $dbi->query($q);
        if ($rec = $dbi->getRow())
            return true;
        else
            return false;
    } else {
        $q = "SELECT $idName FROM $tableName WHERE $fieldName = '$fieldValue' AND $idName != '$idValue' LIMIT 0,1";
        $dbi->query($q);
        if ($rec = $dbi->getRow())
            return true;
        else
            return false;
    }
}

/**
 * Sql Check Duplicates
 *
 * @access: public
 * @return: boll
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function _sqlCheckDuplicates(&$obj, $maction, $tableName, $arrFieldsValue, $idName, $idValue = '')
{
    global $dbi;

    $sep = "[&&]";
    $msgErr = "";
    $msgErrTmp = "One or many of the following association:                      ";
    if (is_array($arrFieldsValue) && count($arrFieldsValue) > 0) {
        $sqlWhere = " (";
        foreach ($arrFieldsValue as $fieldName => $fieldValue) {
            $fieldValue = _sqlEscValue($fieldValue);

            $arrTmpF = explode($sep, $fieldName);
            $noFileds = count($arrTmpF);
            $arrTmpV = explode($sep, $fieldValue);
            $noValues = count($arrTmpV);

            if ($noFileds > 1 && $noFileds == $noValues) {
                $sqlWhere .= " (";
                foreach ($arrTmpF as $k => $f) {
                    $sqlWhere .= " TRIM({$f}) = '" . trim($arrTmpV[$k]) . "' AND ";
                }
                $sqlWhere .= "1) OR ";
            } else {
                $sqlWhere .= " TRIM({$fieldName}) = '" . trim($fieldValue) . "' OR ";
            }

            $msgErrTmp .= "\\n     - $fieldName => $fieldValue ";
        }
        $sqlWhere = substr($sqlWhere, 0, strlen($sqlWhere) - 3) . ") ";

        $msgErrTmp .= "\\ndoesn\\'t respect the unique conditions!\\n";

        if ($idValue != '') {
            $sqlWhere .= " AND $idName != '$idValue'";
            $_GET['act'] = 'upd';
            $_GET[$idName] = $idValue;
            $msgErr = "Edit Operation - Error!\\n\\n";
        } else
            $msgErr = "Add Operation - Error!\\n\\n";

        $msgErr .= $msgErrTmp;

        $q = "
			SELECT 
				$idName 
			FROM 
				$tableName 
			WHERE 
				$sqlWhere
			LIMIT 0,1
		";
        $dbi->query($q);
        if ($rec = $dbi->getRow()) {
            if (isset($_POST['act']))
                unset($_POST['act']);

            global $smarty;

            $smarty->assign("msgErr", $msgErr);

            eval("\$obj->\$maction();");

            return true;
        } else
            return false;
    } else {
        echo "Invalid fileds definition!";
        exit();
    }
}

/**
 * Check Field Exist
 *
 * @access: public
 * @return: bool
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlCheckFieldExist($tableName, $fieldName, $fieldValue, $fieldName2 = '', $fieldValue2 = '')
{
    global $dbi;

    $sqlWhere = "";
    if ($fieldName2 != '')
        $sqlWhere = " AND $fieldName2 = '$fieldValue2' ";

    $q = "SELECT $fieldName FROM $tableName WHERE $fieldName = '$fieldValue' $sqlWhere LIMIT 0,1";
    $dbi->query($q);
    if ($rec = $dbi->getRow())
        return true;
    else
        return false;
}

/**
 * Get New Id
 *
 * @access: public
 * @return: bool
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.01.2008 (dd.mm.YYYY)
 */
function _sqlGetNewId($tableName)
{
    global $dbi;

    return $dbi->nextId($tableName);
}

/* ############################################ DAO USEFUL FUNCTIONS ############################################ */
function getTableFields($tableName, $ini_file)
{
    $db_info = parse_ini_file($ini_file, true);

    $table_info = $db_info[strtolower($tableName)];

    $tableData = array(
        "fields" => array(),
        "keys" => array()
    );

    foreach ($table_info as $field => $type) {
        $tableData["fields"][] = $field;
    }

    if (isset($db_info[strtolower($tableName) . "__keys"])) {
        $table_key_info = $db_info[strtolower($tableName) . "__keys"];
        foreach ($table_key_info as $key => $type) {
            $tableData["keys"][] = $key;
        }
    }

    return $tableData;
}

/**
 * DAO Get Row Content
 *
 * @param: $tableName = table name | $idName = id name | $idValue = id value
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 13.01.2008 (dd.mm.YYYY)
 */
function daoGetRowContent($tableName, $idName, $idValue, $idName2 = '', $idValue2 = '')
{
    $daoRow = DB_DataObject::factory($tableName);
    $daoRow->whereAdd("{$idName} = {$idValue}");
    if ($idName2 != '')
        $daoRow->whereAdd("{$idName2} = {$idValue2}");
    $daoRow->orderBy($idName);
    $daoRow->limit(0, 1);
    $daoRow->find();
    $c = $daoRow->count();
    if ($c == 1) {
        $daoRow->fetch();
        $ret = $daoRow->toArray();
    } else
        $ret = false;

    $daoRow->free();

    return $ret;
}

/**
 * DAO Check Field Exist
 *
 * @access: public
 * @return: bool
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function daoCheckFieldExist($tableName, $fieldName, $fieldValue, $fieldName2 = '', $fieldValue2 = '')
{
    $daoCheck = DB_DataObject::factory($tableName);

    $daoCheck->whereAdd("{$fieldName} = '{$fieldValue}'");
    if ($fieldName2 != '')
        $daoCheck->whereAdd("{$fieldName2} = '{$fieldValue2}'");

    $daoCheck->limit(0, 1);
    $c = $daoCheck->count();
    $daoCheck->free();

    if ($c)
        return true;
    else
        return false;
}

/**
 * DAO Sql get field content
 *
 * @param: $table = table name | $fieldname = name of filed | $idName = id name | $idValue = id value
 * @access: public
 * @return: field name
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.08.2008 (dd.mm.YYYY)
 */
function daoGetFieldContent($tableName, $fieldName, $idName, $idValue, $idName2 = '', $idValue2 = '')
{
    $daoInfo = DB_DataObject::factory($tableName);
    $daoInfo->whereAdd("{$idName} = '{$idValue}'");
    if ($idName2 != '')
        $daoInfo->whereAdd("{$idName2} = '{$idValue2}'");
    $daoInfo->orderBy($fieldName);
    $daoInfo->limit(0, 1);
    $daoInfo->find();
    $daoInfo->fetch();
    $v = $daoInfo->$fieldName;
    $daoInfo->free();
    if ($v)
        return $v;
    else
        return false;
}

/**
 * DAO Get Table Content
 *
 * @param $tableName =
 *            table name
 * @param $idName =
 *            id name
 * @param $fieldName =
 *            name of filed
 * @param $conditionSql =
 *            condition de pour filtrer le resultat obtenu
 * @param $fieldOrder =
 *            name of filed for order
 * @param $outType =
 *            output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function daoGetTableContentFiltered($tableName, $idName, $fieldName, $conditionSql = null, $fieldOrder = '', $outType = 0)
{
    $daoContent = DB_DataObject::factory($tableName);

    $ret = array();

    if ($outType == 2);
    else {
        $daoContent->selectAdd();
        $daoContent->selectAdd("$idName, $fieldName");
    }

    if (! is_null($conditionSql) && is_string($conditionSql))
        $daoContent->whereAdd($conditionSql);

    if ('' == $fieldOrder && $fieldName != '')
        $daoContent->orderBy($fieldName);
    if ($fieldOrder != '') {
        if ($fieldOrder != $fieldName && $fieldName != '')
            $daoContent->orderBy("{$fieldOrder}, {$fieldName}");
        else
            $daoContent->orderBy($fieldOrder);
    }

    $daoContent->find();

    if (1 == $outType || 2 == $outType) {
        while ($daoContent->fetch())
            $ret[] = $daoContent->toArray();
    } else {
        while ($daoContent->fetch()) {
            $rec = $daoContent->toArray();

            $ret[0][] = $rec[$idName];
            $ret[1][] = $rec[$fieldName];
        }
    }

    $daoContent->free();

    return $ret;
}

/**
 * DAO Get Table Content
 *
 * @param: $tableName = table name | $idName = id name | $fieldName = name of filed | $fieldOrder = name of filed for order | $outType = output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function daoGetTableContent($tableName, $idName, $fieldName, $fieldOrder = '', $outType = 0)
{
    $daoContent = DB_DataObject::factory($tableName);

    $ret = array();

    if ($outType == 2);
    else {
        $daoContent->selectAdd();
        $daoContent->selectAdd("$idName, $fieldName");
    }

    if ('' == $fieldOrder && $fieldName != '')
        $daoContent->orderBy($fieldName);
    if ($fieldOrder != '') {
        if ($fieldOrder != $fieldName && $fieldName != '')
            $daoContent->orderBy("{$fieldOrder}, {$fieldName}");
        else
            $daoContent->orderBy($fieldOrder);
    }

    $daoContent->find();

    if (1 == $outType || 2 == $outType) {
        while ($daoContent->fetch())
            $ret[] = $daoContent->toArray();
    } else {
        while ($daoContent->fetch()) {
            $rec = $daoContent->toArray();

            $ret[0][] = $rec[$idName];
            $ret[1][] = $rec[$fieldName];
        }
    }

    $daoContent->free();

    return $ret;
}

/**
 * DAO Get Table Content
 *
 * @param: $tableName = table name | $idName = id name | $fieldName = name of filed | $fieldOrder = name of filed for order | $outType = output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function doctrineGetTableContent($entityManager, $tableName, $idName, $fieldName, $fieldOrder = null, $outType = 0)
{
    return doctrineGetTableContentFiltered($entityManager, $tableName, $idName, $fieldName, null, $fieldOrder, $outType);
}

/**
 * DAO Get Table Content
 *
 * @param $tableName =
 *            table name
 * @param $idName =
 *            id name
 * @param $fieldName =
 *            name of filed
 * @param $conditionSql =
 *            condition de pour filtrer le resultat obtenu
 * @param $fieldOrder =
 *            name of filed for order
 * @param $outType =
 *            output type
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function doctrineGetTableContentFiltered($entityManager, $tableName, $idName, $fieldName, $conditionSql = null, $fieldOrder = null, $outType = 0)
{
    $queryBuilder = $entityManager->createQueryBuilder();

    if ($outType == 2) {
        $queryBuilder->select('dao');
    } else {
        $queryBuilder->select('dao.' . $idName . ', dao.' . $fieldName);
    }

    $queryBuilder->from($tableName, 'dao');

    if (! is_null($conditionSql) && is_string($conditionSql) && trim($conditionSql) != '') {
        $queryBuilder->andWhere($conditionSql);
    }

    if (! is_null($fieldOrder) && trim($fieldOrder) != '' && $fieldOrder != $fieldName) {
        $queryBuilder->orderBy('dao.' . $fieldOrder);
    }

    $queryBuilder->addOrderBy('dao.' . $fieldName);

    $ret = array();

    if (1 == $outType || 2 == $outType) {
        $ret = $queryBuilder->getQuery()->getArrayResult();
    } else {
        $resultArray = $queryBuilder->getQuery()->getArrayResult();
        foreach ($resultArray as $result) {
            $ret[0][] = $result[$idName];
            $ret[1][] = $result[$fieldName];
        }
    }

    return $ret;
}

/**
 * DAO Check Field Exist
 *
 * @access: public
 * @return: bool
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function doctrineCheckFieldExist($entityManager, $tableName, $fieldName, $fieldValue, $fieldName2 = null, $fieldValue2 = null)
{
    $queryBuilder = $entityManager->createQueryBuilder();
    $queryBuilder->select('dao');
    $queryBuilder->from($tableName, 'dao');
    $queryBuilder->andWhere('dao.' . $fieldName . '=:val1')->setParameter('val1', $fieldValue);
    if (! is_null($fieldName2)) {
        $queryBuilder->andWhere('dao.' . $fieldName2 . '=:val2')->setParameter('val2', $fieldValue2);
    }

    $result= ! empty($queryBuilder->getQuery()->setMaxResults(1)->getResult());
    
    return $result;
}

/**
 * Delete ligne for a given field value
 *
 * @param EntityManager $entityManager
 * @param string $tableName
 *            Entity classname on which applying the delete action
 * @param string $fieldName
 *            Field name for the mandatory delete filter
 * @param string $fieldValue
 *            Field value for the mandatory delete filter
 * @param string $fieldName2
 *            Field name for an optional delete filter
 * @param string $fieldValue2
 *            Field value for an optional delete filter
 */
function doctrineDelete($entityManager, $tableName, $fieldName, $fieldValue, $fieldName2 = null, $fieldValue2 = null)
{
    $queryBuilder = $entityManager->createQueryBuilder();
    $queryBuilder->delete($tableName, 'dao');
    $queryBuilder->andWhere('dao.' . $fieldName . '=:val1')->setParameter('val1', $fieldValue);
    if (! is_null($fieldName2)) {
        $queryBuilder->andWhere('dao.' . $fieldName2 . '=:val2')->setParameter('val2', $fieldValue2);
    }
    $queryBuilder->getQuery()->execute();
}

/**
 * Convert ENtity field Name to table column name.
 *
 * @param EntityManager $entityManager
 * @param string $doctrineEntityClass
 *            Entity class name
 * @param array $doctrineDataArray
 *            Array of Doctrine entity fieldName / field value
 * @param array $alias
 *            List of alias for specific field if needed
 * @param int $recursiveLevel
 *            If >0 recurse the associations for the entity to the level given
 *            
 * @return mixed[] Array with database field name/ field value
 */
function doctrineArrayToLegacy($entityManager, $doctrineEntityClass, $doctrineDataArray, $alias = array(), $recursiveLevel = 0, $flat = false)
{
    $classMetadata = $entityManager->getClassMetadata($doctrineEntityClass);
    $legacyDataArray = array();

    if (is_null($alias)) {
        $alias = array();
    }

    // Pour chaque champ qui ne serait pas une association
    foreach ($classMetadata->getColumnNames() as $column) {
        $valueToSet = null;
        // Si des données sont fournies
        if (! is_null($doctrineDataArray)) {
            // On recupere la valeur pour la colonne à partir de son nom de champ dans l'objet
            if (array_key_exists($classMetadata->getFieldName($column), $doctrineDataArray)) {
                $valueToSet = $doctrineDataArray[$classMetadata->getFieldName($column)];
            } else {
                if (array_key_exists($column, $doctrineDataArray)) {
                    $valueToSet = $doctrineDataArray[$column];
                }
            }
        }

        // S'il y a un alias pour la colonne
        if (array_key_exists($column, $alias)) {
            // On enregistre la valeur avec l'alias pour clef
            $legacyDataArray[$alias[$column]] = $valueToSet;
        } else {
            // On enregistre la valeur avec la colonne comme clef
            $legacyDataArray[$column] = $valueToSet;
        }
    }

    // Si recursivité
    if ($recursiveLevel > 0) {
        // On diminue d'un le niveau de recursivité pour les appels suivants
        $recursiveLevel --;

        // Pour chaque association
        foreach ($classMetadata->getAssociationMappings() as $association) {
            // Si la classe possède l'association
            if ($association['isOwningSide'] != 1) {
                continue;
            }

            // Contiendra les valeurs de l'association
            $associationValue = null;

            // Si aucune données dans le tableau de données à convertir
            if (is_null($doctrineDataArray)) {
                // On initialise a un tableau vide pour les appels recursifs
                $doctrineDataArray = array();
            }

            // Si le champ de l'association est présente dans le tableau de données
            if (array_key_exists($association['fieldName'], $doctrineDataArray)) {
                // On appelle recursivement en transmettant les données de l'association
                $associationValue = doctrineArrayToLegacy($entityManager, $association['targetEntity'], $doctrineDataArray[$association['fieldName']], $alias, $recursiveLevel, $flat);
            } // Si l'association n'est pas présente dans le tableau de données
            else {
                // On appelle recursivement en transmettant un tableau vide
                // Cela permettra d'avoir les clefs dans le resultats même pour les éléments absents en théorie
                $associationValue = doctrineArrayToLegacy($entityManager, $association['targetEntity'], array(), $alias, $recursiveLevel, $flat);
            }

            // Si on doit retourner un tableau a une dimension
            if ($flat) {
                // On fusionne les données actuelle avec les données de l'associations
                $legacyDataArray = array_merge($legacyDataArray, $associationValue);
            } // Si on doit retourner un tableau multidimensionnel avec les associations en sous tableau
            else {
                // S'il y a un alias pour le champ
                if (array_key_exists($association['fieldName'], $alias)) {
                    // On utilise l'alias comme clef pour le champ
                    $legacyDataArray[$alias[$association['fieldName']]] = $associationValue;
                } else {
                    // On utilise le champ comme clef
                    $legacyDataArray[$association['fieldName']] = $associationValue;
                }
            }
        }
    }

    return $legacyDataArray;
}

function doctrineEntityToLegacy(EntityManager $entityManager, $entity, $alias=array(), $recursiveLevel=0, $flat=false){
    
    $legacyDataArray=array();
    if(!is_null($entity) && is_object($entity)){
        $classMetadata=$entityManager->getClassMetadata(get_class($entity));
        
        
        if(is_null($alias)){
            $alias=array();
        }
        
        //Pour chaque champ qui ne serait pas une association
        foreach($classMetadata->getColumnNames() as $column){
            
            $valueToSet=$classMetadata->getFieldValue($entity,$classMetadata->getFieldName($column));
            
            //S'il y a un alias pour la colonne
            if(array_key_exists($column, $alias)){
                //On enregistre la valeur avec l'alias pour clef
                $legacyDataArray[$alias[$column]]=$valueToSet;
            }
            else{
                //On enregistre la valeur avec la colonne comme clef
                $legacyDataArray[$column]=$valueToSet;
            }
        }
        
        
        //Si recursivité
        if($recursiveLevel>0){
            //On diminue d'un le niveau de recursivité pour les appels suivants
            $recursiveLevel--;
            
            //Pour chaque association
            foreach($classMetadata->getAssociationMappings() as $association){
                
                //Contiendra les valeurs de l'association
                $associationValue=null;
                
                //Si aucune données dans le tableau de données à convertir
                if(!is_null($associatedEntity=$classMetadata->getFieldValue($entity, $association['fieldName']))){
                    //Si l'association est une collection
                    if($classMetadata->isCollectionValuedAssociation($association['fieldName'])){
                        //On chargera les données dans un tableau
                        $associationValue=array();
                        //Pour chaque entité de la collection
                        foreach($associatedEntity as $item){
                            //On en recupere les données sous forme de tableau et on l'ajoute au tableau representant la collection
                            $associationValue[]=doctrineEntityToLegacy($entityManager, $item, $alias, $recursiveLevel,$flat );
                        }
                    }
                    //Si l'association est un objet simple
                    else{
                        //Si la valeur de l'entité est bien un objet
                        if(is_object($associatedEntity)){
                            //On récupère les données sous la forme d'un tableau
                            $associationValue=doctrineEntityToLegacy($entityManager, $associatedEntity, $alias, $recursiveLevel,$flat );
                        }
                        //Si c'est une valeur
                        else{
                            //On prend en compte juste la valeur
                            $associationValue=$associatedEntity;
                        }
                    }
                }
                
                //Si on doit retourner un tableau a une dimension
                if($flat){
                    //Si on a des données pour l'association
                    if(!is_null($associationValue)){
                        //Si l'association est une collection, on ne conservera que la première entrée
                        if($classMetadata->isCollectionValuedAssociation($association['fieldName'])){
                            if(!empty($associationValue)){
                                //On fusionne les données actuelle avec les données de l'associations
                                $legacyDataArray=array_merge($legacyDataArray,$associationValue[0]);
                            }
                            else{
                                //On fusionne les données actuelle avec l'identifiant de l'entité
                                //$legacyDataArray=array_merge($legacyDataArray,array($association['fieldName']=>null));
                            }
                        }
                        else{
                            //Si la valeur est un tableau correspondant au données de l'entité associée
                            if(is_array($associationValue)){
                                //On fusionne les données actuelle avec les données de l'associations
                                $legacyDataArray=array_merge($legacyDataArray,$associationValue);
                            }
                            //Si la valeur est juste l'identifiant de l'entité associée
                            else{
//                                 //On fusionne les données actuelle avec l'identifiant de l'entité
//                                 $legacyDataArray=array_merge($legacyDataArray,array($association['fieldName']=>$associationValue));
                            }
                        }
                    }
                }
                //Si on doit retourner un tableau multidimensionnel avec les associations en sous tableau
                else{
                    
                    //S'il y a un alias pour le champ
                    if(array_key_exists($association['fieldName'], $alias)){
                        //On utilise l'alias comme clef pour le champ
                        $legacyDataArray[$alias[$association['fieldName']]] =$associationValue;
                    }
                    else{
                        //On utilise le champ comme clef
                        $legacyDataArray[$association['fieldName']]=$associationValue;
                    }
                }
            }
        }
    }
    
    return $legacyDataArray;
}

/**
 * Convert ENtity field Name to table column name.
 *
 * @param EntityManager $entityManager
 * @param string $doctrineEntityClass
 *            Entity class name
 * @param array $doctrineDataArray
 *            Array of Doctrine entity fieldName / field value
 * @param array $alias
 *            List of alias for specific field if needed
 * @param int $recursiveLevel
 *            If >0 recurse the associations for the entity to the level given
 *            
 * @return mixed[] Array with database field name/ field value
 */
function doctrineObjectToLegacy($entityManager, $doctrineEntityClass, $doctrineDataObject, $alias = array(), $recursiveLevel = 0)
{
    $classMetadata = $entityManager->getClassMetadata($doctrineEntityClass);
    $legacyDataArray = array();

    foreach ($classMetadata->getFieldNames() as $field) {

        $classMetadata->getIdentifierColumnNames();

        $legacyDataArray[$classMetadata->getColumnName($field)] = $classMetadata->getFieldValue($doctrineDataObject, $field);
    }

    foreach ($classMetadata->getAssociationMappings() as $association) {
        $object = $classMetadata->getFieldValue($doctrineDataObject, $association['fieldName']);

        if (! is_null($object)) {

            $legacyDataArray[$classMetadata->getColumnName($association['fieldName'])] = $entityManager->getUnitOfWork()->getSingleIdentifierValue($object);
        } else {
            $legacyDataArray[$classMetadata->getColumnName($association['fieldName'])] = null;
        }
    }

    // if($recursiveLevel>0){
    // foreach($classMetadata->getAssociationMappings() as $association){

    // if($association['isOwningSide']!=1){
    // continue;
    // }
    // $mappingsDatas=array();

    // if(array_key_exists($association['fieldName'], $doctrineDataArray)){
    // $mappingsDatas=doctrineArrayToLegacy($entityManager, $association['targetEntity'], $doctrineDataArray[$association['fieldName']], $alias, --$recursiveLevel);
    // }
    // else{
    // $mappingsDatas[]=doctrineArrayToLegacy($entityManager, $association['targetEntity'], array(), $alias, --$recursiveLevel);
    // }

    // if(array_key_exists($association['fieldName'], $alias)){
    // $legacyDataArray[$alias[$association['fieldName']]]=$mappingsDatas;
    // }
    // else{
    // $legacyDataArray[$association['fieldName']]=$mappingsDatas;
    // }
    // }
    // }
    return $legacyDataArray;
}

/**
 * DAO Sql get field content
 *
 * @param: $table = table name | $fieldname = name of filed | $idName = id name | $idValue = id value
 * @access: public
 * @return: field name
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 11.08.2008 (dd.mm.YYYY)
 */
function doctrineGetFieldContent($entityManager, $tableName, $fieldName, $idName, $idValue, $idName2 = null, $idValue2 = null)
{
    $queryBuilder = $entityManager->createQueryBuilder();
    $queryBuilder->select('dao');
    $queryBuilder->from($tableName, 'dao');
    $queryBuilder->andWhere('dao.' . $idName . '=:val1')->setParameter('val1', $idValue);
    if (! is_null($idName2)) {
        $queryBuilder->andWhere('dao.' . $idName2 . '=:val2')->setParameter('val2', $idValue2);
    }

    $rowContent = $queryBuilder->getQuery()->getArrayResult();

    if (count($rowContent) == 1) {
        return $rowContent[0][$fieldName];
    } else {
        return false;
    }

    // $daoInfo = DB_DataObject::factory($tableName);
    // $daoInfo->whereAdd("{$idName} = '{$idValue}'");
    // if($idName2!='')
    // $daoInfo->whereAdd("{$idName2} = '{$idValue2}'");
    // $daoInfo->orderBy($fieldName);
    // $daoInfo->limit(0, 1);
    // $daoInfo->find();
    // $daoInfo->fetch();
    // $v=$daoInfo->$fieldName;
    // $daoInfo->free();
    // if($v)
    // return $v;
    // else
    // return false;
}

/**
 * DAO Get Row Content
 *
 * @param: $tableName = table name | $idName = id name | $idValue = id value
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 13.01.2008 (dd.mm.YYYY)
 */
function doctrineGetRowContent($entityManager, $tableName, $idName, $idValue, $idName2 = null, $idValue2 = null, $toLegacy = false)
{
    $queryBuilder = $entityManager->createQueryBuilder();
    $queryBuilder->select('dao');
    $queryBuilder->from($tableName, 'dao');
    $queryBuilder->andWhere('dao.' . $idName . '=:val1')->setParameter('val1', $idValue);
    if (! is_null($idName2)) {
        $queryBuilder->andWhere('dao.' . $idName2 . '=:val2')->setParameter('val2', $idValue2);
    }

    $rowContent = $queryBuilder->getQuery()->getArrayResult();
    if (count($rowContent) == 1) {
        if ($toLegacy) {
            return doctrineArrayToLegacy($entityManager, $tableName, $rowContent[0]);
        } else {
            return $rowContent[0];
        }
    } else {
        return false;
    }
}

/**
 * Methode qui initialise ou met à jour
 * @param EntityManager $entityManager
 * @param string $entityClass
 * @param array $formDatas
 * @param bool $saveOnExit
 * @return object
 */
function doctrineEntityFromForm(EntityManager $entityManager, string $entityClass,array $formDatas = array(), bool $saveOnExit=false)
{

    // On recupere les métadonnées de la classe
    $cm = $entityManager->getClassMetadata($entityClass);

    // Entité qui sera créée ou mise à jour
    $entity = null;
    
    // Si le formulaire contient un identifiant, c'est une mise à jour
    if (false !== array_key_exists($cm->getSingleIdentifierColumnName(), $formDatas)) {
        // Si la valeur de l'identifiant n'est pas vide
        if (! empty($formDatas[$cm->getSingleIdentifierColumnName()])) {
            // On recupere l'entité
            $entity = $entityManager->find($entityClass, $formDatas[$cm->getSingleIdentifierColumnName()]);
        } // Sinon c'est un ajout
        else {
            $entity = new $entityClass();
        }
    } // S'il n'y a pas d'identifiant, c'est un ajout
    else {
        $entity = new $entityClass();
    }

    // Pour chaque champ dans le formulaire
    foreach ($formDatas as $column => $value) {
        try {
            // On récupère le nom du champ Doctrine pour le nom de colonne
            $field = $cm->getFieldForColumn($column);
        } catch (Exception $inexistantField) {
            continue;
        }

        // On récupère le nom du champ Doctrine pour le nom de colonne
        $field = $cm->getFieldForColumn($column);
        // Si le champ est une association
        if (false !== array_search($field, $cm->getAssociationNames())) {
            // On récupère le nom de la classe cible de l'association
            $targetClass = $cm->getAssociationTargetClass($field);
            // On récupère une référence representant l'objet à positionner sur l'entité actuelle
            $ref = $entityManager->getReference($targetClass, $value);
            // On positionne la référence de l'objet lié à l'entité courante
            $cm->setFieldValue($entity, $field, $ref);
        } // Si le champ n'est pas une association
        else {
            if ('datetime' == strtolower($cm->getTypeOfField($field)) && ! ($value instanceof DateTime)) {
                // On assigne la valeur au champ
                $cm->setFieldValue($entity, $field, new DateTime($value));
            } else {
                // On assigne la valeur au champ
                $cm->setFieldValue($entity, $field, $value);
            }
        }
    }
    
    if($saveOnExit){
        $entityManager->persist($entity);
        $entityManager->flush();
    }

    return $entity;
}

?>