<?php
abstract class Dba {
	protected $dbo;
	protected $debug;

	/**
	 * Disconnect from database and free resources used
	 */
	abstract function disconnect();
	
	/**
	 * Retrieve all results in a single fetch
	 *
	 * @param string [$sql] Select query to execute
	 * @param bool [$mode] Fetch mode assoc (default - false), indexed (true)
	 * @return array Resulting lines in an associative/indexed array
	 */
	abstract function queryAll($sql, $mode = false);
	
	/**
	 * Load the result set of a query to be parsed
	 *
	 * @param string [$sql] Select query to execute
	 * @return int Index of result set 
	 */
	abstract function query($sql);
	
	/**
	 * Parse a result set
	 *
	 * @param int [$idx] Index of result set to parse (default - work with last result index)
	 * @param bool [$mode] Fetch mode associative/indexed (default false - associative)
	 * @return array Current parsed row or false if end is reached
	 */
	abstract function getRow($idx = false, $mode = false);
	
	/**
	 * Get the first column from the first row
	 *
	 * @param string [$sql] Select query to execute
	 * @return string Field value
	 */
	abstract function getOne($sql);
	
	/**
	 * Execute a data manipulation query (that doesn't need a result set stored)
	 *
	 * @param string [$sql] Data manipulation query
	 */
	abstract function execute($sql);
	
	/**
	 * Get Last Insert Id
	 *
	 * @param string [$obj] Obj to create sequence for - table name usually
	 */
	abstract function lastInsertId();
	
	/**
	 * Create a sequence for an object
	 *
	 * @param string [$obj] Obj to create sequence for - table name usually
	 */
	abstract function nextId($obj);
	
	/**
	 * Number of rows in a query
	 *
	 * @param string [$sql] Query to get number of rows for
	 */
	abstract function noRows($sql);
	
	/**
	 * Custom error handler
	 *
	 * @param any [$obj] The object to throw error for
	 */
	abstract protected function errHandler($obj);
	
	/**
	 * Change debugger state
	 *
	 * @param bool [$state] The state to put debugger in
	 */
	function setDebug($state) {
		$this->debug = $state;
	}
}
?>