<?php
require_once(COMPONENT_DIR . 'dba.class.php');

class DbiMdb2 extends Dba {
	protected $result;
	protected $result_idx;
	
	public function __construct($dsn_arr, $options = ''){
		$dsn = $dsn_arr['type'] . '://' . $dsn_arr['user'] . ':' . $dsn_arr['pass'] . '@' . $dsn_arr['host'] . '/' . $dsn_arr['db'];
		$this->dbo =& MDB2::connect($dsn, $options);
		$this->errHandler($this->dbo);
		
		$this->setDebug(true);
		
		$this->result = array();
		$this->result_idx = -1;
    }
    
	function disconnect() {
		foreach ($this->result as $res)
			if (!PEAR::isError($res))
				$res->free();
		if (isset($res)) unset($res);
		unset($this->result);
        $this->dbo->disconnect();
    }

	function errHandler($obj) {
		if (!$this->debug) return;
		
		if (PEAR::isError($obj)) {
			$this->disconnect();
		    die($obj->getMessage() . '<br>' . str_replace('[', "<br>[", $obj->getUserInfo()));
		}
    }
    
    function queryAll($sql, $limit = false, $mode = false) {
    	$this->dbo->setFetchMode($mode ? MDB2_FETCHMODE_ASSOC : MDB2_FETCHMODE_ORDERED);
    	
    	if (is_array($limit) && sizeof($limit) == 2)
    		$this->dbo->setLimit($limit[1], $limit[0]);
   		$data =& $this->dbo->queryAll($sql);
    	$this->errHandler($data);
    	
    	if (sizeof($data))
    		return $data;
    	else
    		return false;
    }
    
	function query($sql, $limit = false) {
    	if (is_array($limit) && sizeof($limit) == 2)
    		$this->dbo->setLimit($limit[1], $limit[0]);
    	$this->result_idx++;
   		$this->result[$this->result_idx] =& $this->dbo->query($sql);
    	$this->errHandler($this->result[$this->result_idx]);
    	
    	return $this->result_idx;
    }
    
	function getRow($idx = false, $mode = false) {
		$this->dbo->setFetchMode($mode ? MDB2_FETCHMODE_ASSOC : MDB2_FETCHMODE_ORDERED);
		
		$idx_ = $idx === false ? $this->result_idx : $idx;
		if (!isset($this->result[$idx_])) die('Invalid result set id!');
		
    	$row = $this->result[$idx_]->fetchRow();
    	if (!$row) {
    		$this->result[$idx_]->free();
    		unset($this->result[$idx_]);
    		if ($idx === false)
    			$this->result_idx--;
    	}
    	
   		return $row;
    }
    
    function getOne($sql) {
    	$this->dbo->setLimit(1, 0);
    	$res =& $this->dbo->query($sql);
    	$this->errHandler($res);
    	$ret = $res->fetchOne();
    	$res->free();
    	unset($res);
    	
   		return $ret;
    }
}
?>