<?php
require_once('dba.class.php');

class DbiPdo extends Dba {
	protected $stmt;
	protected $stmt_idx;

	public function __construct($dsn_arr){
		$dsn = $dsn_arr['type'] . ':host=' . $dsn_arr['host'] . ';dbname=' . $dsn_arr['db'];
		try {
			$this->dbo = new PDO($dsn, $dsn_arr['user'], $dsn_arr['pass']);
			$this->dbo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$this->dbo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);
		}
		catch (PDOException $e) {
			$this->errHandler($e);
		}

		$this->stmt = array();
		$this->stmt_idx = -1;
    }

	function disconnect() {
		unset($this->stmt, $this->stmt_idx);
        $this->dbo = null;
    }

	protected function errHandler($e) {
		if (!$this->debug) return;
		$this->disconnect();
		echo "<pre style=\"text-align:left; color:#B70000;\">";
		var_dump($e);
		echo "</pre>";
	    die("<strong style=\"text-align:left; color:#B70000;\">".$e->getMessage()."</strong>");
    }

    function queryAll($sql, $mode = false) {
    	try {
    		$stmt = $this->dbo->prepare($sql);
    		$stmt->execute();
    		$rows = $stmt->fetchAll($mode ? PDO::FETCH_NUM : PDO::FETCH_ASSOC);
    		unset($stmt);
    		return $rows;
   		}
		catch (PDOException $e) {
			$this->errHandler($e);
		}
    }

	function query($sql) {
    	$this->stmt_idx++;
    	
    	// debug & profiler	start
		global $profiler;
		if(1==DEBUG) $profiler->enterSection($sql);
    	
		try {
			$this->stmt[$this->stmt_idx] = $this->dbo->prepare($sql);
			$this->stmt[$this->stmt_idx]->execute();
		}
		catch (PDOException $e) {
			$this->errHandler($e);
		}
		
		// debug & profiler	end 
		if(1==DEBUG) $profiler->leaveSection($sql);
		
    	return $this->stmt_idx;
    }

	function getRow($idx = false, $mode = false) {
		$idx_ = $idx === false ? $this->stmt_idx : $idx;
		
		if (!isset($this->stmt[$idx_])) die('Invalid stmt set id!');

    	$row = $this->stmt[$idx_]->fetch($mode ? PDO::FETCH_NUM : PDO::FETCH_ASSOC);
    	if (!$row) {
    		unset($this->stmt[$idx_]);
    		if ($idx === false)
    			$this->stmt_idx--;
    	}
   		
    	return $row;
    }

    function getOne($sql) {
   		try {
    		$stmt = $this->dbo->prepare($sql);
    		$stmt->execute();
    		$row = $stmt->fetch(PDO::FETCH_NUM);
    		unset($stmt);
    		return $row[0];
   		}
		catch (PDOException $e) {
			$this->errHandler($e);
		}
    }

	function execute($sql) {   		
		try {
    		$stmt = $this->dbo->prepare($sql);
    		$stmt->execute();
   		}
		catch (PDOException $e) {
			$this->errHandler($e);
		}
    }
    
    function noRows($sql) {
        $stmt = $this->dbo->prepare($sql);
        $stmt->execute();
        return $stmt->rowCount();
    }
    
    function nextId($obj, $objIdName='') {
    	if (!$obj || !is_string($obj)) return false;
    	
    	if($objIdName=='')
    		$objIdName="{$obj}_id";
    	
    	$table = $obj . '_seq';
    	if (!$this->getOne("show table status like '$table'")) {
    		$this->execute("create table $table (id int(11))");
    		$this->execute("insert into $table set id = '0'");
    	}
    	$val1 = $this->getOne("select {$objIdName} from $obj order by {$objIdName} desc limit 1");
    	$val2 = $this->getOne("select id from $table");
    	
    	$val = ($val1 > $val2 ? $val1 : $val2) + 1;
        if ($val2)
    	    $this->execute("update $table set id = '$val'");
        else
            $this->execute("insert into $table set id = '$val'");
    	
    	return $val;
    }
    
    function lastInsertId() {
    	return $this->dbo->lastInsertId();
    }
}
?>