<?php
require(LIB_DIR."mail/mailer.lib.php");

/**
 * Send Mail
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function send_mail($toMail, $fromMail='', $fromName='', $message, $subject='', $files=array(), $isHTML=true)
{		
	$mail = new PHPMailer();
		
	if($fromMail=='')	
		$mail->From = EMAIL_FROM_ADDR;
	else 
		$mail->From = $fromMail;
		
	if($fromName=='')	
		$mail->FromName = EMAIL_FROM_NAME;
	else 
		$mail->FromName = $fromName;	
	
	$mail->Host     = "localhost";
	$mail->Mailer   = (defined("MAILER") ? MAILER:"mail"); //"mail", "sendmail", "smtp"
	
	// Now you only need to add the necessary stuff
	if(is_array($toMail))
	{
		foreach($toMail as $k=>$v)
		{
			$mail->AddBCC($v, "");
		}
	}
	else
		$mail->AddAddress($toMail, "");
		
	$mail->Subject = $subject;
	$mail->Body    = $message;
	$mail->IsHTML($isHTML);
	
	if(is_array($files) && count($files)>0)
	{
		while(list($key, $val) = each($files)) 			
			$mail->AddAttachment($val, $key);
	}
		
	$mail->Send();
	
	$mail->ClearAllRecipients();
    $mail->ClearAttachments();
}
?>