<?php
/**
* Affiche le debug
*
*/
function debug($string)
{
	echo "<pre>";
	var_dump($string);
	echo "</pre>";
}

function write_file($filename,$data) 
{ 
	@$fp = fopen( $filename, "w"); 
  	if ( $fp ) 
  	{ 
	    fwrite( $fp, $data); 
    	fclose( $fp ); 
  	} 
} 

function write_gzfile($filename,$data) 
{ 
	$gz = gzopen($filename,'w9');
	gzwrite($gz, $data);
	gzclose($gz);
}


function read_file($filename)
{ 
	if (file_exists($filename))
		return implode("",file($filename));
	else
	{
		echo "fichier introuvable : $filename<br>\n";
		return false;
	}
}

function get_file_ext($filename)
{
	$tab_temp = explode(".",$filename);
	$tab_temp = array_reverse($tab_temp);
	

	return $tab_temp[0];
}

function ip2int($ip) {
  $ex = explode(".", $ip);
  if (count($ex)!=4) return -1;
  list($a, $b, $c, $d) = $ex;
  $a = $a*16777216;
  $b = $b*65536;
  $c = $c*256;
  $ret = $a+$b+$c+$d;
  if ($ret<0) {return 0;}
  else {return $ret;}
}

//Remove cdata from xml (simplexml problem)
function uncdata($xml)
{
    // States:
    //
    //     'out'
    //     '<'
    //     '<!'
    //     '<!['
    //     '<![C'
    //     '<![CD'
    //     '<![CDAT'
    //     '<![CDATA'
    //     'in'
    //     ']'
    //     ']]'
    //
    // (Yes, the states a represented by strings.) 
    //

    $state = 'out';
    $a = str_split($xml);
    
	
    $new_xml = '';

    foreach ($a AS $k => $v) {

        // Deal with "state".
        switch ( $state ) {
            case 'out':
                if ( '<' == $v ) {
                    $state = $v;
                } else {
                    $new_xml .= $v;
                }
            break;

            case '<':
                if ( '!' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

             case '<!':
                if ( '[' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case '<![':
                if ( 'C' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case '<![C':
                if ( 'D' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case '<![CD':
                if ( 'A' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case '<![CDA':
                if ( 'T' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case '<![CDAT':
                if ( 'A' == $v  ) {
                    $state = $state . $v;
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case '<![CDATA':
                if ( '[' == $v  ) {


                    $cdata = '';
                    $state = 'in';
                } else {
                    $new_xml .= $state . $v;
                    $state = 'out';
                }
            break;

            case 'in':
                if ( ']' == $v ) {
                    $state = $v;
                } else {
                    $cdata .= $v;
                }
            break;

            case ']':
                if (  ']' == $v  ) {
                    $state = $state . $v;
                } else {
                    $cdata .= $state . $v;
                    $state = 'in';
                }
            break;

            case ']]':
                if (  '>' == $v  ) {
                    $new_xml .= str_replace('>','&gt;',
                                str_replace('<','&lt;',
                                str_replace('"','&quot;',
                                str_replace('&','&amp;',
                                $cdata))));
                    $state = 'out';
                } else {
                    $cdata .= $state . $v;
                    $state = 'in';
                }
            break;
        } // switch

    }

    //
    // Return.
    //
        return $new_xml;

}

function redirect($url)
{
  header("Request-URI: $url"); 
  header("Content-Location: $url");
  header("Location: $url");
}

function write_log($logfile,$str)
{
	$fp=fopen($logfile,"a");
	fputs($fp,date("Y-m-d H:i:s")." - ".$str."\n");
	fclose($fp);
}

function str_decode($data,$target_charset="ISO-8859-1")
{
	$source_charset = mb_detect_encoding($data,"auto");
	
	if($source_charset)
	{
		$data = iconv($source_charset, $target_charset, $data);
	}
	
	return $data;
}

//extract digits from a string
function number_clean($nr_str)
{
	$nr_ret = "";
	
	for($i=0;$i<strlen($nr_str);$i++)
	{
		if ($nr_str[$i]==(string)intval($nr_str[$i]))
			$nr_ret.=$nr_str[$i];
			
	}

	return $nr_ret;
}

function get_lang()
{
	global $smarty;
	
	$lang_iso = 'fr';
	$smarty->config_load("trans_$lang_iso.conf");
}

function ocr_decode($file,$format="STRING")
{
	$tmp_img = DATA_DIR."tmp/tmp.gif";
	
	copy($file,$tmp_img);
	
	$cmd = CONVERT_BIN." $tmp_img -border 2x2 -bordercolor white ".DATA_DIR."tmp/tmp.pnm";

	exec($cmd);
	
	$cmd = GOCR_BIN." ".DATA_DIR."tmp/tmp.pnm  -o ".DATA_DIR."tmp/toto.txt";
	exec($cmd);

	$result = file_get_contents(DATA_DIR."tmp/toto.txt");

	if ($format=="INT")
	{
		$result = str_replace("O","0",$result);
		$result = str_replace("l","1",$result);
		$result = str_replace("I","1",$result);
	}
		
	return trim($result);
	
}

function rewrite_escape($url, $splitter = '-')
{
	$url = remove_accent(strtolower(utf8_decode($url)));
    $url = str_replace('_', '-', $url);
	$url = preg_replace('/[^\w\d]+/', $splitter, $url);
	$url = preg_replace('/(^-+)?(-+$)?/', '', $url);
	$url = urlencode($url);
	return $url;
}

function unhtmlentities ($string) 
{
	// Remplace les entit�s num�riques
	$string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
	$string = preg_replace('~&#([0-9]+);~e', 'chr(\\1)', $string);
	
	// Remplace les entit�s lit�rales
	$trans_tbl = get_html_translation_table (HTML_ENTITIES);
	$trans_tbl = array_flip ($trans_tbl);
	
	return strtr ($string, $trans_tbl);
}

function sql_value($value)
{
    $value = mysql_escape_string(stripslashes($value));

    return $value;
}

function sql_ft_value($value)
{
    if ($value!="")
    {
        $value = sql_value($value);

        $value = "+".str_replace(" "," +",$value);
    }

    return $value;
}

function get_date($date,$day_pos,$month_pos,$year_pos, $hour_pos=null, $min_pos=null)
{
	if (mb_detect_encoding($date)=="UTF-8" and !eregi("\?",utf8_decode($date)))
		$date = utf8_decode($date);
		
	$date = remove_accent($date);
	$date = strtolower($date);
	
	$tmp = explode(" ",$date);
	$d = sprintf("%02d",$tmp[$day_pos]);
	
	switch($tmp[$month_pos])
	{
		case "janvier":
		$m = '01';
		break;

		case "fevrier":
		$m = '02';
		break;
		
		case "mars":
		$m = '03';
		break;	
		
		case "avril":
		$m = '04';
		break;	
		
		case "mai":
		$m = '05';
		break;	
		
		case "juin":
		$m = '06';
		break;	
		
		case "juillet":
		$m = '07';
		break;	
		
		case "aout":
		case "aout":
		$m = '08';
		break;	
		
		case "septembre":
		case "sept":
		$m = '09';
		break;	
		
		case "oct":
		case "octobre":
		$m = '10';
		break;	
		
		case "nov":
		case "novembre":
		$m = '11';
		break;	
		
		case "dec":
		case "decembre":
		$m = '12';
		break;	
	}
	if ($year_pos==null)
	{
		if (intval(date("m")>$m))
			$y = date("Y")+1;
		else
			$y = date("Y");
	}
	else
		$y = $tmp[$year_pos];
		
	if ($hour_pos!=null)
		$H = $tmp[$hour_pos];
	if ($min_pos!=null)
		$M = $tmp[$min_pos];
		
	if (isset($H) && isset($M))
		return("$y-$m-$d $H:$M");
	else		
		return($y."-".$m."-".$d);
}

function mem_usage() {
	echo 'Memory usage: ' . number_format(memory_get_usage() , 5) . '<br>';
}

function get_phone($str)
{
	$str = strip_tags($str);
	$from = array("."," ","\n","-",":",);
	$to = array("","","","","");
	
	$str = trim(str_replace($from,$to,$str));
	preg_match("/^(.*)([0-9]{10})(.*)/s",$str,$matches);

	if(isset($matches[2]))
		return $matches[2];
	else
		return null;
}

function get_zip($str)
{
	$str = strip_tags($str);
	$from = array("."," ","\n","-",":","/",);
	$to = array("","","","","","");
	
	$str = trim(str_replace($from,$to,$str));
	preg_match("/^(.*)([0-9]{5})(.*)/s",$str,$matches);

	if(isset($matches[2]))
		return $matches[2];
	else
		return null;
}

?>