<?php

//#########################################################################//
//# Utile
//#
//# Author: CFlorin (E-mail: colotin_f@yahoo.com)
//# Date: 22.01.2004
//#########################################################################//

/**
 * Get IP
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function getIP($cookie=0) 
{	
	$ip = "0.0.0.0";
	if (getenv("HTTP_CLIENT_IP")) $ip = getenv("HTTP_CLIENT_IP"); 
	elseif(getenv("HTTP_X_FORWARDED_FOR")) $ip = getenv("HTTP_X_FORWARDED_FOR"); 
	elseif(getenv("REMOTE_ADDR")) $ip = getenv("REMOTE_ADDR"); 
	else $ip = "0.0.0.0"; 
	
	$ip=trim($ip);
	
	if(1==$cookie)
	{
		if(isset($_COOKIE[VAR_COOKIE_IP]) && $_COOKIE[VAR_COOKIE_IP]!='')
			$ip=$_COOKIE[VAR_COOKIE_IP];
		else
			setcookie(VAR_COOKIE_IP, $ip, time()+3600*24*1);//1 days 
	}
	
	return $ip;
}

/**
 * Get Session Id
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function getSessId()
{
	return session_id();
}

/**
 * Redirect
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 22.01.2004 (dd.mm.YYYY)
*/
function redirect($url)
{	
	global $dbi;
	
	if(is_object($dbi))
		$dbi->disconnect();
	
	header("Request-URI: $url"); 
	header("Content-Location: $url"); 
	header("Location: $url");
	exit;
}

/**
 * Init class variables
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 05.04.2005 (dd.mm.YYYY)
*/	
function objInitVar(&$obj, $tplName, $moduleName, $pagingAction, $tableName, $idName, $flagName)
{
	global $smarty;
	
	if($tplName!='') 		
		$obj->tplName = $tplName;
	if($moduleName!='' && isset($obj->moduleName))
		$obj->moduleName = $moduleName;
	if($pagingAction!='') 
		$obj->pagingAction = $pagingAction;
	if($tableName!='' && isset($obj->tableName))
		$obj->tableName	= $tableName;
	if($idName!='' && isset($obj->idName))
		$obj->idName = $idName;		
	if($flagName!='' && isset($obj->flagName))
		$obj->flagName = $flagName;
	
	if(isset($obj->tableName))
		$smarty->assign("tableName", $obj->tableName);
	if(isset($obj->idName))
		$smarty->assign("idName", $obj->idName);
	if(isset($obj->flagName))
		$smarty->assign("flagName", $obj->flagName);
	
	if(isset($obj->uploadDir))
		$smarty->assign("uploadDir", (defined('UPLOAD_DIR') ? str_replace(UPLOAD_DIR, '', $obj->uploadDir) : $obj->uploadDir));	
		
	if(isset($obj->arrFileFields))
		$smarty->assign("arrFileFields", $obj->arrFileFields);
}

/**
 * Prepare Table Fields
 *
 * @access: public
 * @return: q_tmp
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 02.07.2005 (dd.mm.YYYY)
*/	
function objPrepareTableFields(&$obj)
{
	if(count($obj->tableFields)>0)
	{
    	$q_tmp = "";
    	foreach($obj->tableFields as $k=>$filedName)
    	{
    		$filedValue = _sqlEscValue(isset($_POST[$filedName]) ? $_POST[$filedName]:0);
    		$q_tmp .= "$filedName = '$filedValue',";
    		
    		//if($filedValue==='') $q_tmp .= "$filedName = DEFAULT,";
    	}
    	
    	$q_tmp = substr($q_tmp, 0, strlen($q_tmp)-1);
    	
    	return $q_tmp;
	}
    else 
    	redirect("admin.php?obj=index&action=page_invalid");
}

/**
 * File Fields Remove Processing
 *
 * $arrFileFields = array(
 *						"sample2_file1"=>array("name"=>"Image Upl 1", "type"=>"image", "processArgs"=>array("scale", 500)),
 *						"sample2_file2"=>array("name"=>"Image Upl 2", "type"=>"nonimage")
 *					);
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 09.04.06
*/
function fileRemProcessing($tableName, $idName, $idValue, $uploadDir, $arrFileFields)
{
	global $dbi;
	
	$uploadDir=UPLOAD_DIR.$uploadDir.'/';
	
	if(isset($arrFileFields) && is_array($arrFileFields) && count($arrFileFields)>0)
	{
		$sqlSel = implode(",", array_keys($arrFileFields));
		
		$q="SELECT {$sqlSel} FROM {$tableName} WHERE {$idName}='{$idValue}'";
		$res_idx = $dbi->query($q);
		while($rec=$dbi->getRow($res_idx))
		{
			foreach($record as $fileField=>$fileName)
			{
				_ffRemoveFile($uploadDir.$fileName);
				
				$q="UPDATE {$tableName} SET {$fileField}='' WHERE {$idName}='{$idValue}'";
				$dbi->execute($q);
			}
		}
	}
}

/**
 * Remove file fromimgupl dir
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 24.06.06
*/
function imgUplRemove($owner, $owner_id)
{
	global $dbi;
	
	$uploadDir=UPLOAD_DIR.'imgupl/';
	$q="SELECT file FROM imgupl WHERE owner='$owner' AND owner_id='$owner_id'";
	$res_idx=$dbi->query($q);
	while($rec=$dbi->getRow($res_idx))
	{
		_ffRemoveFile($uploadDir.$record[0]);
	}
	$q="DELETE FROM imgupl WHERE owner='$owner' AND owner_id='$owner_id'";
	$dbi->execute($q);
}

/**
 * File Fields Upl Processing
 * $arrFileFields = array(
 *						"sample2_file1"=>array("name"=>"Image Upl 1", "type"=>"image", "processArgs"=>array("scale", 500)),
 *						"sample2_file2"=>array("name"=>"Image Upl 2", "type"=>"nonimage"),
 *						"sample3_file3"=>array("name"=>"Image Upl 2", "filePrefix"=>"", "type"=>"nonimage") 						
 *					);
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 09.04.06
*/
function fileUplProcessing($tableName, $idName, $idValue, $uploadDir, $arrFileFields)
{
	global $dbi;
	
	$uploadDir=UPLOAD_DIR.$uploadDir.'/';
	
	//===> upload files
    if(isset($arrFileFields) && is_array($arrFileFields) && count($arrFileFields)>0)
    {
    	//include this only if you use file upl
		include_once(LIB_DIR.'upload/upload.class.php');
		
    	foreach($arrFileFields as $fileUpl=>$uplInfo)
    	{
	    	$oldFile = _sqlGetFieldContent($tableName, $fileUpl, $idName, $idValue);
	    	
    		if(isset($_POST[$fileUpl.'_del']) && $oldFile!='')
	    	{
	    		_ffRemoveFile($uploadDir.$oldFile);
				
				$q="UPDATE {$tableName} SET {$fileUpl}='' WHERE {$idName}={$idValue}";
		        $dbi->execute($q);
	    	}
	    	elseif(!isset($_POST[$fileUpl.'_del']))
	    	{
	    		$strArgs="";
	    		if(isset($uplInfo['processArgs']) && is_array($uplInfo['processArgs']) && count($uplInfo['processArgs'])>0)
        		{
        			foreach($uplInfo['processArgs'] as $k=>$arg)
        				$strArgs .= "'{$arg}', ";
        			if($strArgs!="")
        				$strArgs=substr($strArgs, 0, strlen($strArgs)-2);
        		}
        		
        		if(isset($uplInfo['filePrefix']) && $uplInfo['filePrefix']!='')
        			$filePrefix=$uplInfo['filePrefix'];
        		else 
        			$filePrefix="{$fileUpl}_{$idValue}";
        			    		
	    		$obj = new upload($fileUpl, $uploadDir, $filePrefix);
		    	$obj->addExtForDst();
		    	eval('$objUplBool=$obj->process('.$strArgs.');');
		    	if($objUplBool)
		    	{
		        	$fileDst = $obj->getFileDst();
		        	unset($obj);
		        	
					if($oldFile!='')
					{
						if($oldFile!=$fileDst) _ffRemoveFile($uploadDir.$oldFile);
					}
					
					$q="UPDATE {$tableName} SET {$fileUpl}='{$fileDst}' WHERE {$idName}={$idValue}";
		        	$dbi->execute($q);
		    	}
		    	eval('if(is_object($objUplBool)) uset($objUplBool);');
	    	}
    	}
    }
    //<===
}

/**
 * Convert array values to htmlentities(values)
 *
 * @access: public
 * @return: array
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 02.07.2005 (dd.mm.YYYY)
*/	
function htmlArrayFilter($arr)
{
	$arrRet = array();
	if(is_array($arr))
	{
		if(defined("CHARSET") && CHARSET=="utf-8")
		{
			foreach($arr as $k=>$v)
			{
				if(is_string($v))
					$arrRet[$k] =  $v;
				else 
					$arrRet[$k] = $v;
			}
		}
		else 
		{
			foreach($arr as $k=>$v)
			{
				if(is_string($v))
					$arrRet[$k] =  htmlentities2($v);
				else 
					$arrRet[$k] = $v;
			}
		}
	}
	return $arrRet;
}

/**
 * Convert str values to htmlentities
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 02.07.2005 (dd.mm.YYYY)
*/	
function htmlentities2($myHTML) 
{
  $translation_table=get_html_translation_table (HTML_ENTITIES,ENT_QUOTES);
  $translation_table[chr(38)] = '&';
  return preg_replace("/&(?![A-Za-z]{0,4}\w{2,3};|#[0-9]{2,3};)/","&amp;" , strtr($myHTML, $translation_table));
}


/**
 * Get currency from  bnr //echo getCurrency();//echo getCurrency('euro');//echo getCurrency('gold');
 *
 * @param: $currency
 * @access: public
 * @return: value or array
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function getCurrency($currency='')
{
	$currencyAssociation = array('euro' => 0, 'usd' => 1, 'gold' => 2);
	$bnr = @file_get_contents('http://www.bnro.ro/Ro/Info/');
	preg_match_all("/<TD class=\"bold\">([0-9,]+)<\/TD>/i", $bnr, $matches);
	//echo "<pre>";print_r($matches);echo "</pre>";
	
	if(isset($matches[1]) && is_array($matches[1]) && count($matches[1])>=3)
	{
		if($currency!='')
			return $matches[1][$currencyAssociation[$currency]]; 
		else 
		{
			$ret=array();
			foreach($currencyAssociation as $k=>$v)
			{
				$ret[$k]=$matches[1][$v];
			}
			
			return $ret;
		}
	}
	else 
		return false;
}

/**
 * Sess cookies destroy
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function sess_cookie_destroy()
{
	$CookieInfo = session_get_cookie_params();
	if ( (empty($CookieInfo['domain'])) && (empty($CookieInfo['secure'])) ) 
	{
		setcookie(session_name(), '', time()-3600, $CookieInfo['path']);
	} 
	elseif (empty($CookieInfo['secure'])) 
	{
		setcookie(session_name(), '', time()-3600, $CookieInfo['path'], $CookieInfo['domain']);
	} 
	else 
	{
		setcookie(session_name(), '', time()-3600, $CookieInfo['path'], $CookieInfo['domain'], $CookieInfo['secure']);
	}
	
}

/**
 * Get smarty var in php
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function getSmartyVar($var)
{
	global $smarty;
	
	return $smarty->get_template_vars($var);
}

/**
 * Check email address
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function checkEmailAddress($email) 
{
	// First, we check that there's one @ symbol, and that the lengths are right
	if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email))
	{
		// Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
		return false;
	}
	// Split it into sections to make life easier
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) 
	{
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) 
		{
			return false;
		}
	}
	  
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1]))// Check if domain is IP. If not, it should be valid domain name
	{
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2) 
		{
			return false; // Not enough parts to domain
		}
		for ($i = 0; $i < sizeof($domain_array); $i++) 
		{
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) 
			{
				return false;
			}
		}
	}
	
	return true;
}

/**
 * Hash function (md5+key)
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function hmac($key, $data)
{
   $b = 64; // byte length for md5
   if (strlen($key) > $b) {
       $key = pack("H*",md5($key));
   }
   $key  = str_pad($key, $b, chr(0x00));
   $ipad = str_pad('', $b, chr(0x36));
   $opad = str_pad('', $b, chr(0x5c));
   $k_ipad = $key ^ $ipad ;
   $k_opad = $key ^ $opad;
   return md5($k_opad  . pack("H*",md5($k_ipad . $data)));
}


/**
 * Profiler Display
 *
 * @access: public
 * @return: string
 * @author: CFlorin (colotin_f@yahoo.com)
*/
function profilerDislay($profiler)
{
   $msg="
   <style type=\"text/css\">
    .profiler {margin:10px 0px 10px 0px; font-size:11px; font-family:Verdana; text-align:left;}
    .profiler table {border-top:1px solid #CCCCCC; border-left:1px solid #CCCCCC;}
	.profiler table th {border-bottom:1px solid #CCCCCC; border-right:1px solid #CCCCCC; background-color: #F4F2F7; color:#7E7E7E; padding:2px; font-size:11px;}
	.profiler td {border-bottom:1px solid #CCCCCC; border-right:1px solid #CCCCCC; color:#7E7E7E; padding:2px; font-size:10px;}
	.profiler .bg0 {background-color:#FFFFFF;}
	.profiler .bg1 {background-color:#F7F7FF;}
   </style>
   <br />
   <div class=\"profiler\">
		<strong>Benchmark Profiler</strong><br />
		<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"> 
			<tr align=\"center\">
				<th width=\"508\">Section Name</th>
				<th>Total Ex. Time</th>
				<th>Netto Ex. Time	</th>
				<th>#Calls</th>
				<th>%</th>
				<th>Calls</th>
				<th>Callers</th>
			</tr>
			";
   			$i=-1;
   			foreach($profiler as $k=>$v)
   			{
   				$i++;
   				$msg.="<tr align=\"center\" class=\"bg".($i%2)."\">";
   				$msg.="<td align=\"left\"><div id=\"bpcallers{$i}\" style=\"width:auto; display:none; background:#009933; border:1px solid #000000; padding:5px; color:#FFFFFF; position:absolute;\"><pre style=\"font-size:11px;\">".print_r($v['callers'], true)."</pre><div style=\"text-align:right;\"><a class=\"link1\" onclick=\"Effect.toggle('bpcallers{$i}','blind'); return false;\" href=\"#\" style=\"color:#FFFFFF;\">close</a></div></div><div id=\"bpcalls{$i}\" style=\"width:auto; display:none; background:#66CCFF; border:1px solid #000000; color:#FFFFFF; padding:5px; position:absolute;\"><pre style=\"font-size:11px;\">".print_r($v['calls'], true)."</pre><div style=\"text-align:right;\"><a class=\"link1\" onclick=\"Effect.toggle('bpcalls{$i}','blind'); return false;\" href=\"#\" style=\"color:#FFFFFF;\">close</a></div></div><div style=\"width:500px; height:60px; overflow-x:hidden; overflow-y:scroll; background-color:#FCF9FF; border:1px solid #CCCCCC; padding:2px;\">{$k}</div></td>";
				$msg.="<td>{$v['time']}</td>";
				$msg.="<td>{$v['netto_time']}</td>";	
				$msg.="<td><a class=\"link1\" onclick=\"Effect.toggle('bpcalls{$i}','blind'); return false;\" href=\"#\">array(".count($v['calls']).")</a></td>";
				$msg.="<td>{$v['percentage']}%</td>";
				$msg.="<td>{$v['num_calls']}</td>";
				$msg.="<td><a class=\"link1\" onclick=\"Effect.toggle('bpcallers{$i}','blind'); return false;\" href=\"#\">array(".count($v['callers']).")</a></td>";
				$msg.="</tr>";
   			}
	$msg.="
		</table>
	</div>
	";
	
	echo $msg;
}

function debug($string)
{
	echo "<pre>";
	var_dump($string);
	echo "</pre>";
}

function var2string($var)
{
	return base64_encode(gzdeflate(serialize($var),9));
}

function string2var($string)
{
	return unserialize(gzinflate(base64_decode($string)));
}

function nl2br_new($str)
{
	$str =  str_replace("\r\n","\n",$str);
	$str =  str_replace("\n","<br />",$str);
	
	return $str;
	
}

function getFloatVal($str)
{
	return floatval(str_replace(',','.',$str));
}

function remove_accent($chaine) 
{ 
   $accent  ="";
   $noaccent="aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby"; 
   return strtr(trim($chaine),$accent,$noaccent);
}
?>