<?php 

namespace RAN\Repository;

use Doctrine\ORM\EntityRepository;

class CentreDeRattachementRepository extends EntityRepository{
    
    public function getCerList($cerCodeFilter=null, $cerNomFilter=null){
        $cerQueryBuilder=$this->getEntityManager()
                    ->createQueryBuilder()
                    ->select('c.cerCode, c.cerNom')
                    ->from('RAN\Entity\CentreDeRattachement', 'c')
                    ->orderBy('c.cerNom');
        
        if(!is_null($cerCodeFilter)){
            $cerQueryBuilder->andWhere('c.cerCode=:cerCode')->setParameter('cerCode', $cerCodeFilter);
        }
                    
        if(!is_null($cerNomFilter)){
            $cerQueryBuilder->andWhere('c.cerNom=:cerNom')->setParameter('cerNom', $cerNomFilter);
        }
                    
        $cerListResult=$cerQueryBuilder->getQuery()->getArrayResult();
        
        $cerList=array();
        foreach($cerListResult as $cerResult){
            $cerList[0][]=$cerResult['cerCode'];
            $cerList[1][]=$cerResult['cerNom'];
        }
        
        return $cerList;
    }
}
?>