<?php 

namespace RAN\Repository;

use Doctrine\ORM\EntityRepository;


class MedecinRepository extends EntityRepository{
    
    public function getMedInfo($per_code){
        $entityManager=$this->getEntityManager();
        
        $qb = $entityManager->createQueryBuilder();
        $qb->select('medecin', 'speMed', 'personne', 'cer', 'adr');
        $qb->from('RAN\Entity\Medecin', 'medecin');
        $qb->leftJoin('medecin.perCode', 'personne');
        $qb->leftJoin('medecin.spmCode', 'speMed');
        $qb->leftJoin('personne.cerCode', 'cer');
        $qb->leftJoin('personne.adrCode', 'adr');
        $qb->andWhere('medecin.perCode=:perCode')->setParameter('perCode', $per_code);
        
        $results = $qb->getQuery()
        ->setHint(\Doctrine\ORM\Query::HINT_REFRESH, true)
        ->getArrayResult();
        
        $medInfo = array();
        if (count($results) == 1) {
            $medecin = $results[0];
            
            $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Medecin', $medecin));
            
            if (array_key_exists('perCode', $medecin)) {
                $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\Personne', $medecin['perCode']));
                
                if (array_key_exists('cerCode', $medecin['perCode'])) {
                    $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\CentreDeRattachement', $medecin['perCode']['cerCode']));
                }
                
                if (array_key_exists('adrCode', $medecin['perCode'])) {
                    if (count($medecin['perCode']['adrCode']) > 0) {
                        $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', $medecin['perCode']['adrCode'][0]));
                    } else {
                        $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\AdressePostale', null));
                    }
                }
            }
            
            if (array_key_exists('spmCode', $medecin)) {
                $medInfo = array_merge($medInfo, doctrineArrayToLegacy($entityManager, 'RAN\Entity\SpecialiteMedicale', $medecin['spmCode']));
            }
        }
        
        return $medInfo;
    }
    
}
?>