<?php
use Doctrine\ORM\Query;

define('TTF_DIR','/usr/share/fonts/truetype/msttcorefonts/');

require_once("../init/init.php");
require_once (LIB_DIR."jpgraph/jpgraph.php");
require_once (LIB_DIR."jpgraph/jpgraph_line.php");
require_once(LIB_DIR."jpgraph/jpgraph_date.php" );
require_once (LIB_DIR."jpgraph/jpgraph_utils.inc.php");

//require_once (LIB_DIR."util.php");
require_once(INCLUDE_DIR . "fct.php");


if(isset($_GET['action']))
	$action=$_GET['action'];
else
	$action="";

switch($action)
{
	case "patpbi_graph" :
		{
			patpbi_graph();
			break;
		}
	default :
		{
				
		}
}

function getDayDiff($date_debut, $date_fin){
	if(!is_numeric($date_debut)) $date_debut=strtotime($date_debut);
	if(!is_numeric($date_fin)) $date_fin=strtotime($date_fin);
	$sec_diff=$date_fin-$date_debut;
	return $sec_diff/86400;
}

function generateTicks(array $date_array, $grace=846000){
	$tick_array=array();
	array_push($tick_array, $date_array[0]-$grace);
	for($i=0; $i<count($date_array); $i++){
		array_push($tick_array,$date_array[$i]);
	}
	array_push($tick_array, $date_array[count($date_array)-1]+$grace);
	return $tick_array;
}



function getNextGreffe($gre_start_code){
    global $entityManager;
    
    $qb=$entityManager->createQueryBuilder();
    
    $qb->select('gre')
        ->from('RAN\Entity\Greffe', 'gre')
        ->from('RAN\Entity\Greffe', 'greFrom')
        ->andWhere('gre.greDate>greFrom.greDate')
        ->andWhere('gre.perCode=greFrom.perCode')
        ->andWhere('greFrom.greCode=:greFromCode')->setParameter('greFromCode', $gre_start_code);
    
    $qb->addOrderBy('gre.greDate');
    $qb->addOrderBy('gre.greCode');
    $qb->setMaxResults(1);
    
    $nextGreffe=$qb->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);
    
    return doctrineArrayToLegacy($entityManager, 'RAN\Entity\Greffe', $nextGreffe);
}




/**
 * PBI Evolutions Graph
 *
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 */
function patpbi_graph(){
    
    global $entityManager;
    
	isset($_GET["show_value"]) ? $show_value = 1 : $show_value = 0;

	if(isset($_GET['pat_per_code']))
	{
		$per_code_pat=(int) $_GET['pat_per_code'];

		$pbiInfo=null;
		
		$datax=array();
		$datax_label=array();
		$datay=array();
		$datay_label=array();

		$greffe=null;
		$greffe_end=null;
		
		//AJOUT RESTRICTION SUR DERNIERE GREFFE
		if (isset($_GET["gre_date"]) && $_GET["gre_date"]!=''){
			$greffe = getGreffe($per_code_pat,$_GET["gre_date"]);
		}
		
		if(!is_null($greffe)){
			$greffe_end=getNextGreffe($greffe['gre_code']);
		}
		
		if(isset($_GET['pbi_code']))
		{
			$pbi_code=(int) $_GET['pbi_code'];
			
			
			$pbiInfo=$entityManager->find('RAN\Entity\ParametresBiologiques', $pbi_code);
			$pbi_libelle=$pbiInfo->getPbiLibelle();
			$pbi_unite_mes=(!is_null($pbiInfo->getUpaCode()) ? $pbiInfo->getUpaCode()->getUpaLibelle() : '');
			
			$qb=$entityManager->createQueryBuilder();
			$qb->select('cspbi','csl', 'pbi', 'upa')
			     ->from('RAN\Entity\ConsultParamBio', 'cspbi')
			     ->join('cspbi.cslCode', 'csl')
			     ->leftJoin('cspbi.pbiCode', 'pbi')
			     ->leftJoin('pbi.upaCode', 'upa');
			
			 if ($greffe != false && !is_null($greffe['gre_date'])){
			     $qb->andWhere('csl.cslDate>=:cslDateBegin')->setParameter('cslDateBegin', $greffe['gre_date']);
			 }
	         
			 if ($greffe_end !=false && !is_null($greffe_end['gre_date'])){
			     $qb->andWhere('csl.cslDate<:cslDateEnd')->setParameter('cslDateEnd', $greffe_end['gre_date']);
			 }

			     
			 $qb->andWhere('csl.perCodePat=:perCodePat')->setParameter('perCodePat', $per_code_pat);
			 $qb->andWhere('cspbi.pbiCode=:pbiCode')->setParameter('pbiCode', $pbi_code);
			 
			 
			 
			 if(isset($_REQUEST['date_debut_intervalle']) && $_REQUEST['date_debut_intervalle']!=''){
			     $a=explode("/", $_REQUEST['date_debut_intervalle']);
			     if(count($a)==3 && is_numeric($a[0]) && is_numeric($a[1]) && is_numeric($a[2])){
			         $qb->andWhere('csl.cslDate>=:cslDateBeginInterval')->setParameter('cslDateBeginInterval', new DateTime($a[2].'-'.$a[1].'-'.$a[0]));
			     }
			 }
			 
			 if(isset($_REQUEST['date_fin_intervalle']) && $_REQUEST['date_fin_intervalle']!=''){
			     $a=explode("/", $_REQUEST['date_fin_intervalle']);
			     if(count($a)==3 && is_numeric($a[0]) && is_numeric($a[1]) && is_numeric($a[2])){
			         $qb->andWhere('csl.cslDate<:cslDateEndInterval')->setParameter('cslDateEndInterval', new DateTime($a[2].'-'.$a[1].'-'.$a[0]));
			     }
			 }
			 
			 $qb->addOrderBy('csl.cslDate');
			 $qb->addOrderBy('csl.cslCode');
			 
			 $cspbis=$qb->getQuery()->setHint(Query::HINT_REFRESH, 1)->getResult();
			 
			 foreach($cspbis as $cspbi){
			     if(is_null($cspbi->getCpbValeur()) || empty($cspbi->getCpbValeur())){
			         continue;
			     }
			     $valeur=(is_numeric($cspbi->getCpbValeur()) ? $cspbi->getCpbValeur() : trim(str_replace(',', '.',$cspbi->getCpbValeur())));
			     if(is_numeric($valeur)){
			         $datax_label[]=$cspbi->getCslCode()->getCslDate()->format('d/m/Y');
			         $datax[]=count($datax)+1;
			         if($cspbi->getPbiCode()->getUpaCode()->getUpaCode()!=PBI_AS_DILUTION){
			             $datay_label[]=$valeur;
			             $datay[]=$valeur;
			         }
			         else{
			             //COURBE DILUTION
			             $datay_label[]='1/'.$valeur;
			             //On utilise la valeur en puissance 2
			             $datay[]=log($valeur)/log(2);
			         }
			     }
			 }
		}
		elseif(isset($_GET['csl_pbi']) && ($_GET['csl_pbi']=='poids' || $_GET['csl_pbi']=='ta' || $_GET['csl_pbi']=='imc'))
		{
			$param='csl_'.$_GET['csl_pbi'];
				
			switch($_GET['csl_pbi']){
				case 'ta':
					$datay[0] = array();
					$datay[1] = array();
					$pbi_libelle='TA systolique';
					$pbi_libelle2='TA diastolique';
					$pbi_unite_mes='mmHg';
					break;
				case 'poids':
					$pbi_libelle='Poids';
					$pbi_unite_mes='Kgs';
					break;
				case 'imc' :
					$pbi_libelle='IMC';
					$pbi_unite_mes='kg/m�';
					break;
				default :
					$pbi_libelle=$param;
					$pbi_unite_mes='?';
			}
				
			$qb=$entityManager->createQueryBuilder();
			$qb->select('csl')
			     ->from('RAN\Entity\Consultation', 'csl');
			
			if ($greffe != false && !is_null($greffe["gre_date"])){
    	        $qb->andWhere('csl.cslDate>=:cslDateBegin')->setParameter('cslDateBegin', $greffe["gre_date"]);
    	    }
            if ($greffe_end !=false && !is_null($greffe_end["gre_date"])){
                $qb->andWhere('csl.cslDate<:cslDateEnd')->setParameter('cslDateEnd', $greffe_end["gre_date"]);
            }
            
            if(isset($_REQUEST['date_debut_intervalle']) && $_REQUEST['date_debut_intervalle']!=''){
                $a=explode("/", $_REQUEST['date_debut_intervalle']);
                if(count($a)==3 && is_numeric($a[0]) && is_numeric($a[1]) && is_numeric($a[2])){
                    $qb->andWhere('csl.cslDate>=:cslDateBeginInterval')->setParameter('cslDateBeginInterval', new DateTime($a[2].'-'.$a[1].'-'.$a[0]));
                }
            }
            
            if(isset($_REQUEST['date_fin_intervalle']) && $_REQUEST['date_fin_intervalle']!=''){
                $a=explode("/", $_REQUEST['date_fin_intervalle']);
                if(count($a)==3 && is_numeric($a[0]) && is_numeric($a[1]) && is_numeric($a[2])){
                    $qb->andWhere('csl.cslDate<:cslDateEndInterval')->setParameter('cslDateEndInterval', new DateTime($a[2].'-'.$a[1].'-'.$a[0]));
                }
            }
            
            $qb->andWhere('csl.perCodePat=:perCodePat')->setParameter('perCodePat', $per_code_pat);
            
            $qb->addOrderBy('csl.cslDate');
            $qb->addOrderBy('csl.cslCode');
                     
            
            
            $csls=$qb->getQuery()->setHint(Query::HINT_REFRESH, 1)->getResult();

    	     foreach($csls as $csl){
    	         switch($_GET['csl_pbi']){
    	             case 'ta' :
    	                 if ($csl->getCslTa()!=0)	{
    	                     $datax[]=count($datax)+1;
    	                     $datax_label[]=$csl->getCslDate()->format('d/m/Y');
    	                     $datay[0][]=$csl->getCslTa();
    	                     $datay[1][]=$csl->getCslTa2();
    	                 }
    	                 break;
    	             case 'poids' :
    	                 if ($csl->getCslPoids()!=0)	{
    	                     $datax_label[]=$csl->getCslDate()->format('d/m/Y');
    	                     $datax[]=count($datax)+1;
    	                     $datay[]=$csl->getCslPoids();
    	                 }
    	                 break;
    	             case 'imc' :
    	                 if ($csl->getCslPoids()!=0 && $csl->getCslTaille()!=0)	{
    	                     $datax_label[]=$csl->getCslDate()->format('d/m/Y');
    	                     $datax[]=count($datax)+1;
    	                     $datay[]=round($csl->getCslPoids()/pow($csl->getCslTaille()/100,2),2);
    	                 }
    	                 break;
    	             default:
    	                 $datay[]=$csl->$param;
    	                 
    	                 
    	         }
     	    }
		}

		$graph_width= isset($_REQUEST['graph_width']) ? $_REQUEST['graph_width'] : 700;
		$graph_height=isset($_REQUEST['graph_height']) ? $_REQUEST['graph_height'] : 500;
		$nb_plots=isset($_REQUEST['nb_plots']) ? $_REQUEST['nb_plots'] : 20;

		// Setup graph
		$graph = new Graph(($graph_width>$graph_width*(count($datax)/$nb_plots) ? $graph_width : $graph_width*(count($datax)/$nb_plots)),$graph_height,"auto");
		$graph->img->SetMargin(60,20,40,90);
		$graph->SetMarginColor('white');
		$graph->SetFrame(false,'darkblue',2);
		if(count($datay)>0){
			$graph->SetScale("textlin", 0, 0, 0, count($datax)+1);
		}
		else{
			$graph->SetScale('textlin',0,10,0, count($datax)+1);
		}
		

		//Setup title
		//On utilise le libell� du param�tre bio comme titre du graph
		$titre_graph=$pbi_libelle;
		//Si une unit� de mesure est pr�sente
		if(strlen(trim($pbi_unite_mes))>0){
			//On ajoute l'unit� de mesure � la l�gende
			$titre_graph.='('.$pbi_unite_mes.')';
		}
		
		$graph->title->Set($titre_graph);//Evolution du param�tres biologiques
		$graph->title->Align('left');
		// Use built in font
		$graph->title->SetFont(FF_ARIAL,FS_NORMAL,14);

		// Slightly adjust the legend from it's default position
		$graph->legend->Pos(0.01,0.963,"right","center");
		$graph->legend->SetFont(FF_ARIAL,FS_BOLD);

		// Setup X-scale
		//$graph->xaxis->SetTickLabels($datax);
		$graph->xaxis->SetFont(FF_ARIAL,FS_NORMAL,8);
		$graph->xaxis->SetLabelAngle(45);
		$graph->xaxis->title->Set("Date");

		if(count($datax)==0) array_push($datax, 0);
		if(count($datax_label)==0) array_push($datax_label, "");
		if(count($datay)==0) array_push($datay, null);
		if(count($datay_label)==0) array_push($datay_label, "");

		if(count($datax)==1) array_push($datax, $datax[0]+1);
		if(count($datax_label)==1) array_push($datax_label, "");
		if(count($datay)==1) array_push($datay, null);
		if(count($datay_label)==1) array_push($datay_label, "");

		$graph->xaxis->SetMajTickPositions($datax, $datax_label);
		$graph->xaxis->SetLabelFormatString('Ymd', true);

		//On indique les valeurs des points en Y
		if(!is_null($pbiInfo) && !is_null($pbiInfo->getUpaCode()) && $pbiInfo->getUpaCode()->getUpaCode()==PBI_AS_DILUTION){
			$graph->yaxis->SetMajTickPositions($datay, $datay_label);
		}
		$graph->yaxis->SetFont(FF_ARIAL,FS_NORMAL,8);
		$graph->yaxis->title->SetFont(FF_ARIAL,FS_NORMAL,8);
		
		//On utilise le libell� du param�tre bio comme l�gende
		$titre_yaxis=$pbi_libelle;
		//Si une unit� de mesure est pr�sente
		if(strlen(trim($pbi_unite_mes))>0){
			//On ajoute l'unit� de mesure � la l�gende
			$titre_yaxis.='('.$pbi_unite_mes.')';
		}
		
		//On indique la l�gende pour l'axe vertical
		$graph->yaxis->title->Set($titre_yaxis);


		if (isset($_GET['csl_pbi']) and $_GET['csl_pbi']=='ta')
		{
			// Create the first line
			$p1 = new LinePlot($datay[0]);
			$p1->mark->SetType(MARK_FILLEDCIRCLE);
			$p1->mark->SetFillColor("red");
			$p1->mark->SetWidth(4);
			$p1->SetColor("blue");
			$p1->SetCenter();
				
			//$p1->SetLegend("$pbi_libelle ($pbi_unite_mes)");
				
			$graph->Add($p1);

			if ($show_value == 1) $p1->value->Show();

			// Create the first line
			$p2 = new LinePlot($datay[1]);
			$p2->mark->SetType(MARK_FILLEDCIRCLE);
			$p2->mark->SetFillColor("red");
			$p2->mark->SetWidth(4);
			$p2->SetColor("red");
			$p2->SetCenter();
				
			//$p2->SetLegend("$pbi_libelle2 ($pbi_unite_mes)");
				
			$graph->Add($p2);

			if ($show_value == 1) $p2->value->Show();
		}
		else
		{
			// Create the first line
			$p1 = new LinePlot($datay, $datax);
			$p1->mark->SetType(MARK_FILLEDCIRCLE);
			$p1->mark->SetFillColor("red");
			$p1->mark->SetWidth(4);
			$p1->SetColor("blue");
			$p1->SetCenter();
				
			//$p1->SetLegend("$pbi_libelle ($pbi_unite_mes)");
			
			$graph->Add($p1);
			
			if ($show_value == 1)$p1->value->Show();
		}

		// Output line
		$graph->Stroke();
	}
}

?>
