var PopupDiv = Class.create();
PopupDiv.obj = null;
PopupDiv.hide = function() {
	if (PopupDiv.obj != null)
		PopupDiv.obj.hide();
}
PopupDiv.prototype = {
  	initialize: function(url) {
		PopupDiv.hide();
		PopupDiv.obj = this;
		
		if ($('popup_div') == null)
			new Insertion.Top(document.body, '<div id="popup_div" style="display: none; position: absolute;"></div>');
		
		this.hcenter = this.center.bindAsEventListener(this);
		this.hhide = this.hide.bindAsEventListener(this);
		
		this.toggleSelects('hidden');		

		var obj = this;
		new Ajax.Updater('popup_div', url, { 
			evalScripts: true,
			onComplete: function() {
				obj.center('_no_trans');
				$('popup_div').show();
				
				//new Draggable('popup_div', { handle: 'popup_div_handle' });
				new Event.observe(window, 'resize', obj.hcenter);
				new Event.observe(window, 'scroll', obj.hcenter);
			}
		});
	},
	
	toggleSelects: function(state) {
		if (Prototype.Browser.IE && document.getElementsByTagName) {
			var selects = document.getElementsByTagName('select');
			
			for (i = 0; i < selects.length; i++)
				Element.setStyle(selects[i], { visibility: state });
		}
	},
	
	hide: function() {
		if ($('popup_div') != null) {
			new Event.stopObserving(window, 'resize', this.hcenter);
			new Event.stopObserving(window, 'scroll', this.hcenter);
			new Event.stopObserving('popup_div_mask', 'click', this.hhide);
			
			$('popup_div').hide();
			$('popup_div').update('');
			$('popup_div_mask').hide();
			this.toggleSelects('visible');
			
			PopupDiv.obj = null;
		}
	},
	
	center: function() {
		if ($('popup_div') == null) return;
		
		this.showMask();
		
		var dim_view = document.viewport.getDimensions();
		var dim_win = $('popup_div').getDimensions();
		if (dim_view.width < dim_win.width)
			x = this.getScrollX() <= dim_win.width - dim_view.width ? 0 : this.getScrollX() - (dim_win.width - dim_view.width);
		else
			x = Math.round(dim_view.width / 2 - dim_win.width / 2) + this.getScrollX();
		if (dim_view.height < dim_win.height)
			y = this.getScrollY() <= dim_win.height - dim_view.height ? 0 : this.getScrollY() - (dim_win.height - dim_view.height);
		else
			y = Math.round(dim_view.height / 2 - dim_win.height / 2) + this.getScrollY();
		
		if (arguments.length == 1 && arguments[0] == '_no_trans')
			$('popup_div').setStyle({ left: x + 'px', top: y + 'px' });
		else {
			var queue = Effect.Queues.get('popup_div');
			queue.each(function(e) { e.cancel() });
			new Effect.Move('popup_div', { duration: 0.5, 'x': x, 'y': y, mode: 'absolute', queue: { position: 'end', scope: 'popup_div' } })
		}
	},
	
	showMask: function() {
		if ($('popup_div_mask') == null)
			new Insertion.Top(document.body, '<div id="popup_div_mask" style="display: none;"></div>');
		if (!$('popup_div_mask').visible())
			new Event.observe('popup_div_mask', 'click', this.hhide);

		var dim_body = $(document.body).getDimensions();
		var dim_view = $(document.viewport).getDimensions();
		$('popup_div_mask').setStyle({ width: dim_view.width > dim_body.width ? dim_view.width : dim_body.width + 'px' });
		$('popup_div_mask').setStyle({ height: dim_view.height > dim_body.height ? dim_view.height : dim_body.height + 'px' });
		
		$('popup_div_mask').show();
	},
	
	getScrollY: function() {
		var sy = 0;
		if (document.documentElement && document.documentElement.scrollTop)
			sy = document.documentElement.scrollTop;
		else if (document.body && document.body.scrollTop) 
			sy = document.body.scrollTop; 
		else if (window.pageYOffset)
			sy = window.pageYOffset;
		else if (window.scrollY)
			sy = window.scrollY;
		return sy;
	},
	
	getScrollX: function() {
		var sx = 0;
		if (document.documentElement && document.documentElement.scrollLeft)
			sx = document.documentElement.scrollLeft;
		else if (document.body && document.body.scrollLeft) 
			sx = document.body.scrollLeft; 
		else if (window.pageXOffset)
			sx = window.pageXOffset;
		else if (window.scrollX)
			sx = window.scrollX;
		return sx;
	}
}
