//JavaScript Document

function calculRatioPC() {
	try {

		if ($("pbi_proteinurie") == null)
			return;

		if ($("pbi_creatininurie") == null)
			return;

		if ($("pbi_proteinurie").value != ""
			&& !isNaN($("pbi_proteinurie").value.replace(",", "."))
			&& !isNaN($("pbi_creatininurie").value.replace(",", "."))
			&& $("pbi_creatininurie").value != "") {

			$("pbi_ratio_proteinurie_creatininurie").value = new Number(
					($("pbi_proteinurie").value.replace(",", ".") / $("pbi_creatininurie").value
							.replace(",", ".")) * 1000).toFixed(1);
		}

		else {

			$("pbi_ratio_proteinurie_creatininurie").value = "";

		}

	}

	catch (err) {

		alert("Une erreur est survenue lors du calcul du param�tre Proetininurie/creatininurie");

	}

}

function calculFEUree() {

	try {

		if ($("pbi_uree_urinaire") == null)
			return;

		uree_urinaire = $("pbi_uree_urinaire").value.replace(",", ".");

		if ($("pbi_creatinine") == null)
			return;

		creatinine = $("pbi_creatinine").value.replace(",", ".");

		if ($("pbi_uree") == null)
			return;

		uree = $("pbi_uree").value.replace(",", ".");

		if ($("pbi_creatininurie") == null)
			return;

		creatininurie = $("pbi_creatininurie").value.replace(",", ".");

		if (checkNumber(uree_urinaire) && checkNumber(creatinine)
				&& checkNumber(uree) && checkNumber(creatininurie)) {

			$("pbi_fe_uree").value = new Number(
					((uree_urinaire * creatinine) / (uree * creatininurie)) / 10)
			.toFixed(2);

		}

		else {

			$("pbi_fe_uree").value = "";

		}

	}

	catch (err) {

		alert("Une erreur est survenue lors du calcul du param�tre FE Uree");

	}

}

function calculClairanceCockroft(age, sexe) {

	try {

		if ($("pbi_poids") == null)
			return;

		poids = $("pbi_poids").value.replace(",", ".");

		if ($("pbi_creatinine") == null)
			return;

		creatinine = $("pbi_creatinine").value.replace(",", ".");

		k = (sexe == 2 ? 1.04 : 1.23);

		if (checkNumber(creatinine)) {

			$("pbi_clairance_cockroft").value = new Number(
					((140 - age) / creatinine) * poids * k).toFixed(1);

		}

		else {

			$("pbi_clairance_cockroft").value = "";

		}

	}

	catch (err) {

		alert("Une erreur est survenue lors du calcul du param�tre Clairance Cockroft : "
				+ e.message);

	}

}

function calculFENA() {

	try {

		if ($("pbi_natriurese") == null)
			return;

		natriurese = $("pbi_natriurese").value.replace(",", ".");

		if ($("pbi_creatinine") == null)
			return;

		creatinine = $("pbi_creatinine").value.replace(",", ".");

		if ($("pbi_sodium") == null)
			return;

		sodium = $("pbi_sodium").value.replace(",", ".");

		if ($("pbi_creatininurie") == null)
			return;

		creatininurie = $("pbi_creatininurie").value.replace(",", ".");

		if (checkNumber(natriurese) && checkNumber(creatinine)
				&& checkNumber(sodium) && checkNumber(creatininurie)) {

			$("pbi_fe_na").value = new Number(
					((natriurese * creatinine) / (sodium * creatininurie)) / 10)
			.toFixed(2);

		}

		else {

			$("pbi_fe_na").value = "";

		}

	}

	catch (err) {

		alert("Une erreur est survenue lors du calcul du param�tre FE NA");

	}

}

function checkNumber(value) {
	return value != '' && value != null && !isNaN(value.replace(",", "."));
}

function getMedicamentInfo(file, medi_code) {

	url = ROOT_HOST + file + '?obj=patient&action=medic_info&medi_code='
	+ medi_code;

	mediInfo = new Array();

	var opt = {

			asynchronous : true,

			evalScripts : true,

			dataType : "xml",

			onSuccess : function(t) {

				alert($(t).find($('medicament')));

			}

	}

	new Ajax.Request(url, opt);

}

function isMedicamentSubstituable(file, medi_code) {

	url = ROOT_HOST + file
	+ '?obj=patient&action=medic_substituable&medi_code=' + medi_code;

	isSubstituable = true;

	var opt = {

			asynchronous : false,

			evalScripts : true,

			onSuccess : function(response) {

				isSubstituable = (1 == response.responseText);

			}

	}

	new Ajax.Request(url, opt);

	return isSubstituable;

}

/**
 * 
 * Get Communes List by Pay
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function setPayCommunes(file, form_name, oblig, pay_code, com_code, width,
		onchange)

{

	url = ROOT_HOST + file + '?obj=ajax&action=set_pay_communes&pay_code='
	+ pay_code + '&com_code=' + com_code + '&width=' + width;

	if (typeof onchange != 'undefined' && onchange >= 1)

	{

		url += '&onchange=' + onchange + '&file=' + file + '&form_name='
		+ form_name + '&oblig=' + oblig;

	}

	var opt = {

			asynchronous : true,

			evalScripts : true,

			onSuccess : function(t) {

				$('targetCommunesBox_' + form_name).innerHTML = t.responseText;

				if (oblig == true)

				{

					eval('document.' + form_name + '.com_code.oblig="true"');

				}

			}

	}

	new Ajax.Request(url, opt);

}

/**
 * 
 * Get Adresses List by Comm
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function setCommAdresses(file, form_name, oblig, com_code, adr_code, width)

{

	url = ROOT_HOST + file + '?obj=ajax&action=set_comm_adresses&com_code='
	+ com_code + '&adr_code=' + adr_code + '&width=' + width;

	var opt = {

			asynchronous : true,

			evalScripts : true,

			onSuccess : function(t) {

				$('targetAdressesBox_' + form_name).innerHTML = t.responseText;

				if (oblig == true)

				{

					eval('document.' + form_name + '.adr_code.oblig="true"');

				}

			}

	}

	new Ajax.Request(url, opt);

}

/**
 * 
 * Delete Multiple Rows
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function deleteMultipleRows(objForm, textMatch)

{

	if (typeof objForm == 'undefined')
		objForm = document.form_list;

	if (typeof textMatch == 'undefined')
		textMatch = 'ids';

	var c = 0;

	var items = objForm.elements;

	for (i = 0; i < items.length; i++)

	{

		if (items[i].type == 'checkbox' && items[i].name.match(textMatch))

			if (items[i].checked == true)

			{

				c++;

				break;

			}

	}

	if (c >= 1)

	{

		objForm.act.value = 'delete';

		if (confirm(txtConfirmDel))

			objForm.submit();

	}

	else

		alert('No rows set!');

}

/**
 * 
 * Edit Row
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function editRow(urlEdit, objForm, textMatch)

{

	if (typeof objForm == 'undefined')
		objForm = document.form_list;

	if (typeof textMatch == 'undefined')
		textMatch = 'ids';

	var c = 0;
	var id = 0;

	var items = objForm.elements;

	for (i = 0; i < items.length; i++)

	{

		if (items[i].type == 'checkbox' && items[i].name.match(textMatch))

			if (items[i].checked == true)

			{

				c++;

				id = items[i].value;

			}

		if (c > 1)

			break;

	}

	if (c == 1)

		window.location = urlEdit + id;

	else if (c == 0)

		alert('Select the row to edit!');

	else

		alert('Select only a row to edit!');

}

/**
 * 
 * Get Communes List by Pay
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function setPrcPbi(file, form_name, prc_code, csl_code)

{

	url = ROOT_HOST + file + '?obj=ajax&action=set_prc_pbi&prc_code='
	+ prc_code + '&csl_code=' + csl_code;

	var opt = {

			asynchronous : true,

			evalScripts : true,

			onSuccess : function(t) {

				$('targetPBIParamBox_' + form_name).innerHTML = t.responseText;

			},

			onFailure : function(r) {
				alert('Erreur lors du chargement des param�tres biologiques :'
						+ r.responseText);
			}

	}

	new Ajax.Request(url, opt);

}

/**
 * 
 * Content menu
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function cMenu(obj_sufix, item_selected, no_items)

{

	for (i = 1; i <= no_items; i++)

	{

		if (i == item_selected)

		{

			$(obj_sufix + 'btn' + i).className = 'btn2Sel';

			$(obj_sufix + i).style.display = 'block';

		}

		else

		{

			$(obj_sufix + 'btn' + i).className = 'btn2';

			$(obj_sufix + i).style.display = 'none';

		}

	}

}

/**
 * 
 * Ajax Medecin Form (case user and non user)
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function setMedecinFormAct(form_type, per_code)

{

	url = ROOT_HOST
	+ 'index.php?obj=ajax&action=set_medecin_form_act&form_type='
	+ form_type + '&per_code=' + per_code;

	var opt = {

			asynchronous : true,

			evalScripts : true,

			onSuccess : function(t) {

				$('medecinFromAct').innerHTML = t.responseText;

				if (form_type == 2)

				{

					document.form_act.spm_code.oblig = 'true';

					// document.form_act.civ_code.oblig='true';

					document.form_act.per_nom.oblig = 'true';

					// document.form_act.per_prenom.oblig='true';

					// document.form_act.adr_cp.oblig='true';

					// document.form_act.adr_ville='true';

					// document.form_act.adr_voie.oblig='true';

					// document.form_act.cer_code.oblig='true';

					document.form_act.per_code.oblig = 'false';

					// setPayCommunes('index.php', 'form_act', true,
					// document.form_act.pay_code.value,
					// document.form_act.com_code_h.value, 168);

				}

				else

				{

					$('per_code').oblig = 'true';

					document.form_act.per_code.oblig = 'true';

				}

			}

	}

	new Ajax.Updater('medecinFromAct', url, opt);

}

/**
 * 
 * Pat Pbi Graph
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function patpbiGraph(pat_per_code, pbi_code)

{

	var id = 'graph_' + pat_per_code + '_' + pbi_code;

	if (document.getElementById(id))

	{

		posX = document.getElementById(id).offsetLeft;

		posY = document.getElementById(id).offsetTop;

		document.getElementById('pHeader').removeChild(
				document.getElementById(id));

	}

	var oDiv = document.createElement("div");

	oDiv.style.position = 'absolute';

	// oDiv.style.left='50%';//parseInt(posX)+'px';

	// oDiv.style.top='50%';//parseInt(posY)+'px';

	oDiv.style.zIndex = '2000';

	oDiv.id = id;

	document.onselectstart = function() {
		return false;
	}

	var content = '<img alt="click to close" title="click to close" onmouseover="this.style.cursor=\'pointer\'" onclick="document.getElementById(\'pHeader\').removeChild(document.getElementById(\''
		+ id
		+ '\'));" src="'
		+ ROOT_HOST
		+ 'jpgraph.php?action=patpbi_graph&pat_per_code='
		+ pat_per_code
		+ '&pbi_code='
		+ pbi_code
		+ '" alt="'
		+ pat_per_code
		+ ', '
		+ pbi_code + '" />';

	oDiv.innerHTML = content;

	if (!document.getElementById(id))

	{

		// document.body.appendChild(oDiv);

		document.getElementById('pHeader').appendChild(oDiv);

	}

}

/**
 * 
 * Patient comment update
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function actPatientComment(per_code_pat, pat_com_type, act)

{

	var pat_com_txt = encodeURIComponent($('pat_com_txt' + pat_com_type).value);

	$('pat_com_txt' + pat_com_type).style.background = 'url(' + ROOT_HOST
	+ 'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST + 'index.php?obj=ajax&action=act_patient_comment';

	var opt = {

			asynchronous : true,

			evalScripts : true,

			method : 'post',

			postBody : 'act=' + act + '&pat_com_txt=' + pat_com_txt
			+ '&per_code_pat=' + per_code_pat + '&pat_com_type='
			+ pat_com_type,

			onSuccess : function(t)

			{

				$('pat_com_txt' + pat_com_type).style.background = '';

				$('pat_com_txt' + pat_com_type).value = t.responseText;

			}

	}

	new Ajax.Request(url, opt);

}

/**
 * 
 * Search Medecin
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function searchMedecin(per_code_pat, csl_code)

{

	var per_nom = $('per_nom').value;

	var per_prenom = $('per_prenom').value;

	var spm_code = $('spm_code').value;

	var com_nom = $('com_nom').value;

	var dep_nom = $('dep_nom').value;

	$('medecin_search_result').style.background = 'url(' + ROOT_HOST
	+ 'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST
	+ 'index.php?obj=ajax&action=medecin_search_result&per_code_pat='
	+ per_code_pat + '&csl_code=' + csl_code;

	var opt = {

			asynchronous : true,

			evalScripts : true,

			method : 'post',

			postBody : 'act=search&per_nom=' + per_nom + '&per_prenom='
			+ per_prenom + '&spm_code=' + spm_code + '&com_nom=' + com_nom
			+ '&dep_nom=' + dep_nom,

			onSuccess : function(t)

			{

				$('medecin_search_result').style.background = '';

				$('medecin_search_result').innerHTML = t.responseText;

			}

	}

	new Ajax.Request(url, opt);

}

/**
 * 
 * Assign Medecin Corespondant
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function medecinCorespondant(per_code_pat, per_code_med, act, csl_code)

{

	$('medecin_corespondant').style.background = 'url(' + ROOT_HOST
	+ 'img/useful/ajax_indicator.gif) no-repeat center center';
	
	url = ROOT_HOST
	+ 'index.php?obj=ajax&action=medecin_corespondant&per_code_med='
	+ per_code_med + '&per_code_pat=' + per_code_pat + '&act=' + act
	+ '&csl_code=' + csl_code;
	
	var opt = {

			asynchronous : true,

			evalScripts : true,

			onSuccess : function(t)

			{

				$('medecin_corespondant').style.background = '';

				$('medecin_corespondant').innerHTML = t.responseText;

			}

	}
	

	new Ajax.Request(url, opt);
	

}

/**
 * 
 * Compte Rendu
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function compteRendu(csl_code, modele_lettre)

{

	$('compte_rendu').style.background = 'url(' + ROOT_HOST
	+ 'img/useful/ajax_indicator.gif) no-repeat center center';

	var url = ROOT_HOST + 'index.php?obj=patient&action=compte_rendu&csl_code='
	+ csl_code;

	if (typeof modele_lettre != 'undefined' && modele_lettre)

		url += '&modele_lettre=' + modele_lettre;

	var opt = {

			asynchronous : true,

			evalScripts : true,

			onSuccess : function(t)

			{

				$('compte_rendu').style.background = '';

				$('compte_rendu').innerHTML = t.responseText;

			}

	}

	new Ajax.Request(url, opt);

}

/**
 * 
 * Print Compte Rendu
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function printCompteRendu(csl_code)

{

	var no_med = $('no_med').value;

	var str_med = '';

	for (i = 0; i < no_med; i++)

	{

		if ($('med' + i).checked == true)

		{

			str_med += $('med' + i).value + '-' + $('cou_lettre' + i).value
			+ ',';

		}

	}

	if (str_med != '')

	{

		var url = 'index.php?obj=patient&action=csl_print&csl_code=' + csl_code;

		popup(url, 810, 800, 'csl_print' + csl_code, 1);

	}

	else

		alert('Vous devez choisir au moins un m�decin');

}

/**
 * 
 * Save Courrier Edite
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function saveCourrierEdite(csl_code){

	if($('no_med')!=null){
		var no_med = $('no_med').value;
	
		var str_med = '';
	
		for (i = 0; i < no_med; i++)
		{
	
			if ($('med' + i).checked == true)
			{
				str_med += $('med' + i).value + '-' + $('cou_lettre' + i).value + ',';
			}
	
		}
	
		$('medecin_corespondant').style.background = 'url(' + ROOT_HOST+ 'img/useful/ajax_indicator.gif) no-repeat center center';
	
		url = ROOT_HOST + 'index.php?obj=ajax&action=save_courrier_edite&csl_code='+ csl_code;
	
		var opt = {
				asynchronous : true,
				evalScripts : true,
				method : 'post',
				postBody : 'act=save&str_med=' + str_med,
				onSuccess : function(t)
				{
					$('medecin_corespondant').style.background = '';
					$('medecin_corespondant').innerHTML = t.responseText;
					window.location.reload(true);
				}
		}
	
		new Ajax.Request(url, opt);
	}

}

/**
 * 
 * Search Medicament
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function searchPrescription(per_code_pat)

{

	var medi_nom_com = $('medi_nom_com').value;

	$('prescription_search_result').style.background = 'url(' + ROOT_HOST
	+ 'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST
	+ 'index.php?obj=patient&action=prescription_search_result&per_code_pat='
	+ per_code_pat;

	// encoding:'ISO-8859-1',

	var opt = {

			asynchronous : true,

			evalScripts : true,

			method : 'post',

			postBody : 'act=search&medi_nom_com=' + medi_nom_com,

			onSuccess : function(t)

			{

				$('prescription_search_result').style.background = '';

				$('prescription_search_result').innerHTML = t.responseText;

			}

	}

	new Ajax.Updater('prescription_search_result', url, opt);

}

/**
 * 
 * Search Medicament
 * 
 * 
 * 
 * @access: public
 * 
 * @return: null
 * 
 * @author: CFlorin (colotin_f@yahoo.com)
 * 
 */

function traitementFormAdd(act)

{

	var str_post = 'act2=' + act;

	var value;

	var form = document.form_act;

	for ( var j = form.elements.length - 1; j >= 0; j--)

	{

		if (form.elements[j].type == "checkbox")

		{

			if (form.elements[j].checked)

				value = 1;

			else

				value = 0;

		}

		else

			value = form.elements[j].value;

		str_post += '&' + form.elements[j].name + '=' + value;

	}

	$('table_form_act').style.background = 'url(' + ROOT_HOST
	+ 'img/useful/ajax_indicator.gif) no-repeat center center';

	url = ROOT_HOST + 'index.php?obj=patient&action=traitement_form_add';

	var opt = {

			asynchronous : true,

			evalScripts : true,

			method : 'post',

			postBody : str_post,

			onSuccess : function(t)

			{

				$('table_form_act').style.background = '';

				$('table_form_act').innerHTML = t.responseText;

				nor = document.form_act.no_pre.value;

				for (i = 0; i <= nor; i++)

				{

					$('pre_quantite' + i).format = 'float';

					$('pre_duree' + i).format = 'integer';

					$('pre_renouvel' + i).format = 'integer';

				}

			}

	}

	new Ajax.Updater('table_form_act', url, opt);

}

var CslBrowser = Class.create();

CslBrowser.prototype = {

		initialize : function(opt) {

			this.wrapper = opt.cont;

			this.no = opt.no;

			this.csl_current = 0;

			this.pagination = opt.pagination;

		},

		browse : function(csl_id) {

			if (csl_id < 0 || csl_id >= this.no)
				return;

			this.csl_hide_all();

			this.csl_show(csl_id)

			$(this.pagination).update((this.csl_current + 1) + " sur " + this.no);

		},

		csl_hide_all : function() {

			for ( var i = 0; i < this.no; i++)

				$(this.wrapper + i).hide()

		},

		csl_show : function(csl_id) {

			$(this.wrapper + csl_id).show()

			this.csl_current = csl_id

		},

		browse_last : function() {

			this.browse(this.no - 1);

		}

}

function clairanceSet(age, sexe)

{

	// DFG = 175 � [(cr�atinin�mie en �mol/l)/88,4]-1,154 � (�ge)-0,203 � (0,742
	// si femme)

	// ca n'apparait pas tr�s bien mais (-1,154) et (-0,203) sont des exposants

	if ($('pbi_creatinine') != null)

	{

		creatinine = $('pbi_creatinine').value;

		if (creatinine != "")

			clairance = 175 * Math.pow(creatinine / 88.4, -1.154)
			* Math.pow(age, -0.203);

		else

			clairance = "";

		if (sexe == 2)

			clairance = clairance * 0.742;

	}

	else

		clairance = "";

	if (clairance != "")

		clairance = Math.round(clairance);

	if (clairance == 0)

		clairance = "";

	if ($('pbi_clairance') != null)

		$('pbi_clairance').value = clairance

}

function cslUnsaveTest()

{

	if (cslUnsave != 2 && typeof (FCKeditorAPI) !== 'undefined')

	{

		var oEditor = FCKeditorAPI.GetInstance('csl_comment');

		if (oEditor.IsDirty() == true) {
			cslUnsave = 1;
		}

		if (cslUnsave == 1) {

			setWaitPage(false);

			return "Vous avez effecu� des changements sans sauvegarder, si vous ne sauvegardez pas ceux ci seront perdus.";

		}
		;

	}

}

function cslResetDirty()

{

	if (typeof (FCKeditorAPI) !== 'undefined')

	{

		var oEditor = FCKeditorAPI.GetInstance('csl_comment');

		// alert(oEditor.IsDirty());

		oEditor.ResetIsDirty();

		// alert(oEditor.IsDirty());

	}

}

/**
 * Methode qui charge l'onglet selectionne donneur ou greffe
 * 
 * @access: public
 * @return: null
 */
function chargeOnglet(name, per_code, gre_code, action)

{
	// on affecte dans str_post les informations qui seront pass�s au controleur
	// pour traitement
	var str_post = '';

	// variable qui contient le formaulaire de saisi
	var form = "";

	// variable qui contient le nom du formulaire selectionner (vivant ou
	// decede), permet au controleur de savoir si c'est un update ou un add
	var saveForm = "";

	// variable qui contient l'url de traitement
	var url = ROOT_HOST + 'index.php?obj=greffe&action=' + name + '&per_code='
	+ per_code;

	// variable qui permet de faire l'appel ajax
	var traitement = true;

	// si le param�tre gre_code (code greffe) n'est pas renseign� on le r�cup�re
	if (gre_code == '') {
		gre_code = document.getElementById("gre_code").value;
	}

	// on concateine � la variable qui va �tre post� le code greffe
	str_post = 'gre_code=' + gre_code;

	// si l'action est diff�rent de add alors c'est que le donneur existe et on
	// recup�re les informations du formulaire pour modification
	// sinon on affiche seulement le template (formulaire vide) correspondant au
	// donneur
	if (action != 'add') {

		var onglet = '';

		var change = false;

		// on test sur quel formulaire on est
		if (document.getElementById("form_onglet").name == "form_greffe_donneur") {
			onglet = "de l'onglet donneur";
			// affecte la valeur correspondant au formulaire donneur pour maj
			saveForm = "form_greffe_donneur";

		} else {
			onglet = "de l'onglet greffe";
			// affecte la valeur correspondant au formulaire greffe pour maj
			saveForm = "form_greffe_greffe";
		}

		// affiche le message de confirmation de la sauvegarde
		change = confirm('Voulez-vous sauvegarder les informations ' + onglet
				+ '?');

		// on test si l'utilisateur valide son choix
		if (change == true) {

			// si l'onglet en cours est le formulaire donneur
			if (saveForm == 'form_greffe_donneur') {

				// cas du formulaire donneur decede
				// test la valeur du champ "dod_transfusion"
				if ($("don_type").value != '' && $("don_type").value != '0'
					&& $("dod_transfusion").value == '2') {
					// si dod_transfusion = non, alors on r�initialise les
					// valeurs suivante a vide lors de la sauvegarde
					if ($("don_cgr").value != '') {
						$("don_cgr").value = '';
					}

					if ($("don_cpa").value != '') {
						$("don_cpa").value = '';
					}

					if ($("don_pfc").value != '') {
						$("don_pfc").value = '';
					}
				}

				// on recupere le formulaire
				form = document.form_greffe_donneur;

				// test les champs obligatoires
				traitement = verifChampOblig('form_greffe_donneur');

			} else {

				if ($("gre_protocole").value != '0'
					&& $("gre_protocole").value == '2') {
					// si protocole = non, alors on r�initialise les valeurs
					// suivante a vide lors de la sauvegarde
					if ($("gre_comment_protocole").value != '') {
						$("gre_comment_protocole").value = '';
					}
				}
				// sinon c'est le formulaire greffe
				// on recupere le formulaire
				form = document.form_greffe_greffe;

				// test les champs obligatoires
				traitement = verifChampOblig('form_greffe_greffe');
			}

			if (traitement) {

				// on recupere les champs du formulaire � poster
				for ( var j = form.elements.length - 1; j >= 0; j--)

				{

					if (form.elements[j].type == "selected")

					{

						liste = form.elements[j];

						value = liste.options[liste.selectedIndex].text;

					}

					else {

						value = form.elements[j].value;

					}

					if (form.elements[j].format == "float"
						|| form.elements[j].format == "SignedFloat") {
						value = form.elements[j].value.replace(",", ".");
					}

					str_post += '&' + form.elements[j].name + '=' + encodeURIComponent(value);

				}

			}

		} else {
			setWaitPage(false);
			return false;
		}
	}

	// concateine le nom du formaulaire pour traitement dans le controleur
	url += '&saveForm=' + saveForm;

	if (traitement) {

		// on effectue l'appel ajax
		new Ajax.Request(
				url,
				{

					method : 'post',

					parameters : str_post,

					asynchronous : true,

					onSuccess : function(response) {
						// on met en couleur l'onglet s�lectionn�
						if (name == 'onglet_donneur') {
							$('onglet_donneur').className = "aSel";
							$('onglet_greffe').className = "";
						} else {
							$('onglet_donneur').className = "";
							$('onglet_greffe').className = "aSel";
						}

						// affiche le formaulaire
						$('consulte_don_gref').innerHTML = '';
						$('consulte_don_gref').innerHTML = response.responseText;

						setWaitPage(false);

					},

					onFailure : function() {

						console.log('echec');

						$('consulte_don_gref').innerHTML = "echec de l'affichage de l'onglet "
							+ name;

						setWaitPage(false);

					}

				});

	} else {
		setWaitPage(false);
	}

}

/**
 * Methode qui affiche le formulaire correspondnat au type de donneur
 * s�lectionner
 * 
 * @access: public
 * @return: null
 */
function displayInfoDonneur(value, per_code)

{
	var type_donneur = "";

	var typeDonneur_existant = "";

	var type = "";

	var change = true;

	var gre_code = document.getElementById("gre_code").value;

	// on r�cup�re la valeur existante du type de donneur
	typeDonneur_existant = document.getElementById("typeDonneur_existant").value;

	if ((typeDonneur_existant != '') && (value != typeDonneur_existant)) {

		change = confirm('Voulez-vous modifier le type de donneur?\n (Les modifications seront effectives lors de la sauvegarde.)');

		if (change == false) {
			// on remet la valeur par defaut
			document.getElementById("don_type").value = typeDonneur_existant;
			value = typeDonneur_existant;
			// met change � true pour recharger le formulaire
			change = true;

			// setWaitPage(false);

		} /*
		 * else {
		 *  // si le type de donneur exisant est un type decede et que le
		 * nouveau type de donneur est aussi un type decede // c'est le meme
		 * formulaire on ne le recharge pas if (((value==1) || (value==2)) &&
		 * ((typeDonneur_existant==1) || (typeDonneur_existant==2))){
		 * 
		 * change=false;
		 * 
		 * setWaitPage(false);
		 *  }
		 *  }
		 */

	}

	// recupere le type de donneur
	if (value == "0") {

		type_donneur = "greffe_donneur_vivant";

	} else {

		if ((value == "1") || (value == "2")) {
			type_donneur = "greffe_donneur_decede";
		}

	}

	// si on a modifier le type de donneur et qu'il est valider
	if (type_donneur !== "" && change) {
		// appel ajax pour afficher le formulaire correspondant au type de
		// donneur s�lectionn�
		var url = ROOT_HOST + 'index.php?obj=greffe&action=' + type_donneur
		+ '&per_code=' + per_code;

		// console.log('avant requ�te!');
		new Ajax.Request(
				url,
				{

					method : 'post',

					parameters : 'gre_code=' + gre_code + '&typeDonneur='
					+ value,

					asynchronous : true,

					onSuccess : function(response) {

						// console.log('sucess!');

						$('consulte_donneur').innerHTML = '';

						$('consulte_donneur').innerHTML = response.responseText;

						// 29-05-2015 : mis en commentaire car l'imc est calcul�
						// aussi pour le donnneur decede
						/*
						 * if (type_donneur=="greffe_donneur_vivant"){ if
						 * (($('don_taille').value!=null ||
						 * $('don_taille').value!='')
						 * &&($('don_poids').value!=null ||
						 * $('don_poids').value!='')){ calculImcDov(); } }
						 */

						setWaitPage(false);

					},

					onFailure : function() {

						console.log('Erreur!');

						setWaitPage(false);

						$('consulte_donneur').innerHTML = "echec de l'affichage du formulaire "
							+ type_donneur;

					}

				});

	} else {
		$('consulte_donneur').innerHTML = '';
	}

}

/**
 * Methode qui ajoute une ligne dans le tableau contionnement immuno supp de
 * l'onglet greffe
 * 
 * @access: public
 * @return: null
 */
function ajouterLigne(url, txtAdd, txtDel, gre_code, per_code) {
	// recupere le nombre de ligne du tableau
	var ligne = document.getElementById("tab_immuno")
	.getElementsByTagName("tr").length;

	var id = ligne;

	var urlAjax = ROOT_HOST
	+ 'index.php?obj=greffe&action=ajoutConditionImminoSupp&per_code='
	+ per_code;

	new Ajax.Request(
			urlAjax,
			{

				method : 'post',

				parameters : 'gre_code=' + gre_code + '&url=' + url
				+ '&txtDel=' + txtDel + '&txtAdd=' + txtAdd + '&ligne='
				+ ligne,

				asynchronous : true,

				onSuccess : function(response) {
					// on ajoute une nouvelle ligne
					var newLigne = document.getElementById("tab_immuno")
					.insertRow(-1); // cr�ation d'une ligne pour ajout
					// en fin de table

					// on affecte la reponse (template d'une ligne d'un tableau)
					// dans la nouvelle ligne
					newLigne.innerHTML = response.responseText;

					// on supprime l'ic�ne ajouter qui se trouve sur la ligne
					// pr�cedente
					document.getElementById("tab_immuno").rows[id - 1].cells[2].innerHTML = '';

					// on recup�re le nombre de ligne du tableau
					var ligne = document.getElementById("tab_immuno")
					.getElementsByTagName('tr').length;
					if (ligne == 3) {
						document.getElementById("tab_immuno").rows[id - 1].cells[1].innerHTML = '<td style="width:10px;"><img src="'
							+ url
							+ 'admin/del.gif" border="0" alt="{#txtTitleDel#}" onclick="supLigne(this,\''
							+ url
							+ '\',\''
							+ txtAdd
							+ '\',\''
							+ txtDel
							+ '\',\''
							+ gre_code
							+ '\',\''
							+ per_code
							+ '\');"/></td>';
					}

					setWaitPage(false);

				},

				onFailure : function() {

					setWaitPage(false);

					alert("echec de la cr�ation de la greffe");

				}

			});
}

/**
 * Methode qui supprime une ligne du tableau contionnement immuno supp de
 * l'onglet greffe
 * 
 * @access: public
 * @return: null
 */
function supLigne(obj, url, txtAdd, txtDel, gre_code, per_code) {
	// on recup�re l'index de la ligne s�lectionn�
	var id = obj.parentNode.parentNode.rowIndex;

	// supprime la ligne s�lectionn�
	document.getElementById("tab_immuno").deleteRow(id);

	// on recup�re le nombre de ligne du tableau
	var ligne = document.getElementById("tab_immuno")
	.getElementsByTagName('tr').length;

	// on ajoute l'ic�ne ajouter a la dernier ligne du tableau
	if (ligne > 1) {
		document.getElementById("tab_immuno").rows[ligne - 1].cells[2].innerHTML = '<td style="width:10px;"><img src="'
			+ url
			+ 'admin/add.gif" border="0" alt="'
			+ txtAdd
			+ '" onclick="ajouterLigne(\''
			+ url
			+ '\',\''
			+ txtAdd
			+ '\',\''
			+ txtDel
			+ '\',\''
			+ gre_code
			+ '\',\''
			+ per_code
			+ '\');"/></td>';
	}

	if (ligne == 1) {
		ajouterLigne(url, txtAdd, txtDel, gre_code, per_code);
	}

}

/**
 * Methode qui affecte les champs obligatoires des diff�rents formulaires et
 * test s'ils sont renseign�s
 * 
 * @access: public
 * @return: null
 */
function verifChampOblig(formulaire_name) {
	var verif_ok = false;
	if (formulaire_name == 'form_greffe') {
		// indique les champs obligatoires
		$('gre_date').oblig = "true";
		$('gre_rang').oblig = "true";
		$('gre_greffon_fonct').oblig = "true";

		// on indique le format des champs
		$('gre_date').format = 'date';
		$('gre_rang').format = 'integer';

		if ($('gre_greffon_fonct').value == '2') {
			// indique les champs obligatoires
			$('gre_date_fin_fnc').oblig = "true";
			$('ffg_code').oblig = "true";

			// on indique le format des champs
			$('gre_date_fin_fnc').format = 'date';
		} else {
			$('gre_date_fin_fnc').oblig = "false";
			$('ffg_code').oblig = "false";

			// on indique le format des champs
			$('gre_date_fin_fnc').format = '';
		}

	}

	if (formulaire_name == 'form_greffe_donneur') {
		if ($("don_type").value == '') {
			// indique les champs obligatoires
			$("don_type").oblig = 'true';
		} else {
//			$('don_numero_cristal').oblig = 'true';
//			$('gsa_code').oblig = 'true';
//			$('don_taille').oblig = 'true';
//			$('don_poids').oblig = 'true';
//			$('don_sexe').oblig = 'true';
//			$('don_age').oblig = 'true';
//			$('cot_code').oblig = 'true';
//			$("hla_code_1_1").oblig = 'true';
//			$("hla_code_1_2").oblig = 'true';
//			$("hla_code_2_1").oblig = 'true';
//			$("hla_code_2_2").oblig = 'true';
//			$("hla_code_4_1").oblig = 'true';
//			$("hla_code_4_2").oblig = 'true';
//			$("hla_code_5_1").oblig = 'true';
//			$("hla_code_5_2").oblig = 'true';
//			// 29-05-2015 : HLA DP non obligatoire
//			// $("hla_code_6_1").oblig='true';
//			// $("hla_code_6_2").oblig='true';
//			$("ser_code_1").oblig = 'true';
//			$("ser_code_2").oblig = 'true';
//			$("ser_code_4").oblig = 'true';
//			$("ser_code_5").oblig = 'true';
//			$("ser_code_6").oblig = 'true';
//			$("ser_code_7").oblig = 'true';
//			$("ser_code_9").oblig = 'true';
//			$("ser_code_10").oblig = 'true';
//			$("ser_code_11").oblig = 'true';

			// on indique le format des champs
			$('don_taille').format = 'entier';
			$('don_poids').format = 'entier';
			$('don_age').format = 'entier';
			$('don_numero_cristal').format = 'entier';
			$("hla_code_1_1").format = 'entier';
			$("hla_code_1_2").format = 'entier';
			$("hla_code_2_1").format = 'entier';
			$("hla_code_2_2").format = 'entier';
			$("hla_code_4_1").format = 'entier';
			$("hla_code_4_2").format = 'entier';
			$("hla_code_5_1").format = 'entier';
			$("hla_code_5_2").format = 'entier';

			$('don_princ').format = 'entier';
			$('don_pol_sup').format = 'entier';
			$("don_pol_inf").format = 'entier';
			$("don_veine").format = 'entier';

			if ($("don_type").value == 0) {
				// indique les champs obligatoires
//				$('dov_nom').oblig = 'true';
//				$('dov_prenom').oblig = 'true';
//				$('par_code').oblig = 'true';
//				$('dov_imc').oblig = 'true';
//				$('dov_robot').oblig = 'true';
//				$('voa_code').oblig = 'true';
//				$('dov_proteonurie').oblig = 'true';
//				$('dov_clair_iso').oblig = 'true';
//				$('dov_clair_calc').oblig = 'true';
//				$('dov_creat').oblig = 'true';

				// on indique le format des champs
				$('dov_imc').format = 'entier';
				$('dov_creat').format = 'float';
				$('dov_clair_calc').format = 'float';
				$('dov_clair_iso').format = 'float';
				$('dov_proteonurie').format = 'float';

			} else {
				// indique les champs obligatoires
//				$('dod_ville').oblig = 'true';
//				$('cad_code').oblig = 'true';
//				$('dod_comment_deces').oblig = 'false';
//				$('dod_crit_etendus').oblig = 'true';
//				$('dod_arret_coeur').oblig = 'true';
//				$('dod_duree_arret_coeur').oblig = 'true';
//				$('dod_pa_moyen').oblig = 'true';
//				$('dod_amines').oblig = 'true';
//				$('dod_transfusion').oblig = 'true';
				if ($('dod_transfusion').value == '1') {
//					$('don_cgr').oblig = 'true';
//					$('don_cpa').oblig = 'true';
//					$('don_pfc').oblig = 'true';

					// on indique le format des champs
					$('don_cgr').format = 'entier';
					$('don_cpa').format = 'entier';
					$('don_pfc').format = 'entier';

				} else {
					$('don_cgr').oblig = 'false';
					$('don_cpa').oblig = 'false';
					$('don_pfc').oblig = 'false';

					$('don_cgr').format = '';
					$('don_cpa').format = '';
					$('don_pfc').format = '';
				}
//				$('don_creat_arrivee').oblig = 'true';
//				$('don_creat_prelev').oblig = 'true';
//				$('don_dfg').oblig = 'true';
				// 29-05-2015 : non obligaoire
				// $('don_uretere').oblig='true';
//				$('lip_perfusion').oblig = 'true';

				// on indique le format des champs
				$('dod_duree_arret_coeur').format = 'entier';
				$('dod_pa_moyen').format = 'entier';

				$('don_creat_arrivee').format = 'float';
				$('don_creat_prelev').format = 'float';
				$('don_dfg').format = 'entier';
			}
		}
	}

	if (formulaire_name == 'form_greffe_greffe') {
		// indique les champs obligatoires
		$('cot_code_donneur').oblig = 'true';
		$('cot_code').oblig = 'true';
		$('gre_en').oblig = 'true';
		//$('gre_isch_totale').oblig = 'true';
		//$('gre_duree_anasto').oblig = 'true';
		//$('gre_sonde_jj').oblig = 'true';
		$('vir_code_1').oblig = 'true';
		$('hla_code_2').oblig = 'true';
		// $('hla_code_3').oblig='true';
		$('hla_code_4').oblig = 'true';
		$('hla_code_5').oblig = 'true';
		// $('hla_code_6').oblig='true';
		//$('rim_code').oblig = 'true';

		// on indique le format des champs
		$('gre_isch_totale').format = 'entier';
		$('gre_duree_anasto').format = 'entier';
		$('gre_dt_der_dialyse').format = 'date';

		// si la valeur de dialyse est oui
		if ($('gre_dialyse').value == '1') {
			$('gre_dt_der_dialyse').oblig = "true";

		} else {
			$('gre_dt_der_dialyse').oblig = '';
		}

	}

	// on test si les champs obligatoires sont renseign�s
	verif_ok = formValidate(formulaire_name, 0);

	return verif_ok;
}

/**
 * Methode qui sauvegarde les informations obligatoires du formulaire
 * 'form_greffe' (champs obligatoire pour la cr�ation d'une greffe)
 * 
 * @access: public
 * @return: null
 */
function sauve_greffe() {

	var gre_code = document.getElementById("gre_code").value;

	var str_post = 'gre_code=' + gre_code;

	var url = ROOT_HOST + 'index.php?obj=greffe&action=sauve_greffe';

	var change = false;

	var creation_ok = false;

	change = change = confirm('Voulez-vous sauvegarder les informations obligatoires � la cr�ation de la greffe ?');

	// test les champs obligatoires pour le formulaire
	creation_ok = verifChampOblig('form_greffe');

	if (change && creation_ok) {

		if ($("gre_greffon_fonct").value == '1') {
			// alert( 'date = '+$("gre_date_fin_fnc").value);
			if ($("gre_date_fin_fnc").value != 0) {
				$("gre_date_fin_fnc").value = '';
			}

			if ($("ffg_code").length > 0) {
				$("ffg_code").value = '';
			}
		}

		new Ajax.Request(
				url,
				{

					method : 'post',

					parameters : Form.Methods.serialize(document.form_greffe),

					asynchronous : true,
					
					onSuccess : function(response) {

						setWaitPage(false);

					},

					onFailure : function() {

						setWaitPage(false);

						alert("Echec de la sauvegarde de la modification de la greffe");

					}

				});

	} else {
		setWaitPage(false);
	}
}

/**
 * Methode qui creer une nouvelle greffe
 * 
 * @access: public
 * @return: null
 */
function creationGreffe(per_code, action) {

	var creation_ok = false;

	// test les champs obligatoires pour le formulaire
	creation_ok = verifChampOblig('form_greffe');

	// on fait l'appel ajax pour creer la date si creation_ok=true
	if (creation_ok) {

		var url = ROOT_HOST
		+ 'index.php?obj=greffe&action=creer_greffe&per_code='
		+ per_code;

		new Ajax.Request(
				url,
				{

					method : 'post',

					parameters : Form.Methods.serialize(document.form_greffe),

					asynchronous : true,
					
					onSuccess : function(response) {

						// on recup�re id de la greffe cr�er
						var gre_code = response.responseText.trim();

						// on affecte le nouvel id au champ gre_code
						document.getElementById("gre_code").value = gre_code;

						// on affecte au bouton avec id
						// 'creer_ou_sauvegarder_greffe' l'action sauve_greffe
						$('creer_ou_sauvegarder_greffe').onclick = function() {
							setWaitPage(true);
							sauve_greffe();
						};

						// on modifie le texte/nom du bouton
						$('creer_ou_sauvegarder_greffe').innerHTML = "Sauvegarder";

						// on affiche l'�l�ment 'greffe_details'
						$('greffe_details').style.display = 'block';

						// on affecte le code javascript a ex�cuter au bouton
						// 'onglet_donneur'
						$('onglet_donneur').onclick = function() {
							setWaitPage(true);
							chargeOnglet('onglet_donneur', per_code, gre_code,
							'add_upd');
						};

						// on affecte le code javascript a ex�cuter au bouton
						// 'onglet_greffe'
						$('onglet_greffe').onclick = function() {
							setWaitPage(true);
							chargeOnglet('onglet_greffe', per_code, gre_code,
							'add_upd');
						};

						// on charge le formulaire donneur par default avec le
						// parametre action = add
						chargeOnglet('onglet_donneur', per_code, gre_code,
						'add');

						// on modifie l'opacit� de la page pour signaler la fin
						// du traitement
						setWaitPage(false);

					},

					onFailure : function() {
						setWaitPage(false);
						alert("echec de la cr�ation de la greffe");

					}

				});

	} else {
		setWaitPage(false);
	}

}

/**
 * Methode qui sauvegarde l'onglet en cours (donneur ou greffe du module greffe)
 * et retourn sur la liste des greffes
 * 
 * @access: public
 * @return: null
 */
function sauve_onglet(onglet, per_code) {
	// recupere le code greffe
	var gre_code = document.getElementById("gre_code").value;
	// initialise url
	var url = ROOT_HOST
	+ 'index.php?obj=greffe&action=sauvegarde_onglet&onglet=' + onglet
	+ '&per_code=' + per_code + '&gre_code=' + gre_code;

	var onglet_save = "";

	var change = false;

	var form = "";

	// test sur quel onglet on effectue la sauvegarde
	if (onglet == 'onglet_greffe') {

		form = document.form_greffe_greffe;

		onglet_save = "de l'onglet greffe";

	} else {

		form = document.form_greffe_donneur;

		onglet_save = "de l'onglet donneur";

	}

	// on affiche la demande de confirmation de la sauvegarde
	change = confirm('Voulez-vous sauvegarder les informations ' + onglet_save
			+ '?');

	// on test la reponse � la demande
	if (change != false) {
		// reponse est oui, on effecte � l'attribut action du formulaire l'url
		// qui effectuera la sauvegarde
		form.action = url;
		// on soumet le formulaire
		form.submit();
		// on d�sative l'opacit� de la page pour dire que le traitement est
		// termin�
		setWaitPage(false);

	} else {
		// r�ponse est non, on d�sative l'opacit� de la page pour dire que le
		// traitement est termin�
		setWaitPage(false);

	}

}

/**
 * Methode qui permet de consulter une greffe sous forme d'une popup div
 * 
 * @access: public
 * @return: null
 */
function consulte_greffe(gre_code) {

	var url = ROOT_HOST
	+ 'index.php?obj=greffe&action=consulte_greffe&gre_code='
	+ gre_code;

	var popup = new PopupDiv(url);

	$('popup_div').onclick = function() {
		popup.hide();
	};

}

/**
 * Methode qui permet d'afficher les champs 'date_fin_fnc' et 'cause' selon la
 * valeur de Greffon fonctionnel
 * 
 * @access: public
 * @return: null
 */
function afficheInfoRepNo(value) {

	if (value == '2') {

		document.getElementById('date_fin_fnc').style.display = 'table-row';

		document.getElementById('cause').style.display = 'table-row';

	} else {

		document.getElementById('date_fin_fnc').style.display = 'none';

		document.getElementById('cause').style.display = 'none';

	}

}

/**
 * Methode qui calcul IMC du donneur vivant
 * 
 * @access: public
 * @return: null
 */
function calculImcDov() {

	var poids = "";

	var taille = "";

	var calcul = 0;
	var idLabel_don_poids = "";
	var idLabel_don_taille = "";

	try {

		if ((document.getElementById('don_poids').value == null)
				|| (document.getElementById('don_poids').value == ''))
			return;
		poids = document.getElementById('don_poids').value;

		if ((document.getElementById('don_taille').value == null)
				|| (document.getElementById('don_taille').value == ''))
			return;
		taille = document.getElementById('don_taille').value;

		if (checkNumber(poids) && checkNumber(poids)) {

			calcul = new Number(poids / ((taille / 100) * (taille / 100)))
			.toFixed(2);

			if (!isNaN(calcul)) {
				document.getElementById('dov_imc').value = calcul;
			} else {
				idLabel_don_poids = returnIdLabel(document
						.getElementById('don_poids'));
				idLabel_don_taille = returnIdLabel(document
						.getElementById('don_taille'));
				alert('Une erreur est survenue lors du calcul IMC.\n La valeur des champs '
						+ document.getElementById(idLabel_don_poids).innerHTML
						+ ' et '
						+ document.getElementById(idLabel_don_taille).innerHTML
						+ ' doit �tre positif.');
			}

		}
	} catch (e) {

		alert("du donneur vivant : " + e.message);

	}
}

/**
 * Methode qui calcul la clairance du donneur vivant
 * 
 * @access: public
 * @return: null
 */
function calculClairanceDov() {

	var creatine = "";

	var age = "";

	var sexe = "";
	var calcul = 0;
	var idLabel_dov_creat = "";
	var idLabel_don_age = "";

	try {

		if ((document.getElementById('dov_creat').value == null)
				|| (document.getElementById('dov_creat').value == ''))
			return;
		creatine = document.getElementById('dov_creat').value.replace(",", ".");

		if ((document.getElementById('don_age').value == null)
				|| (document.getElementById('don_age').value == ''))
			return;
		age = document.getElementById('don_age').value;

		if ((document.getElementById('don_sexe').value == null)
				|| (document.getElementById('don_sexe').value == ''))
			return;
		sexe = document.getElementById('don_sexe').value;

		if (checkNumber(creatine) && (sexe == '1')) {
			calcul = new Number(186 * Math.pow((creatine * 0.0113), -1.154)
					* Math.pow(age, -0.203)).toFixed(2);
		}

		if (checkNumber(creatine) && (sexe == '2')) {
			calcul = new Number(186 * Math.pow((creatine * 0.0113), -1.154)
					* Math.pow(age, -0.203) * 0.742).toFixed(2);
		}

		if (!isNaN(calcul)) {
			document.getElementById('dov_clair_calc').value = calcul;
		} else {
			idLabel_dov_creat = returnIdLabel(document
					.getElementById('dov_creat'));
			idLabel_don_age = returnIdLabel(document.getElementById('don_age'));
			alert('Une erreur est survenue lors du calcul de la Clairance calcul�e.\n La valeur des champs '
					+ document.getElementById(idLabel_dov_creat).innerHTML
					+ ' et '
					+ document.getElementById(idLabel_don_age).innerHTML
					+ ' doit �tre positif.');
		}
	} catch (e) {

		alert("Une erreur est survenue lors du calcul de la Clairance calcul�e du donneur vivant : "
				+ e.message);
	}
}

/**
 * Methode qui affiche ou non le bandeau du donneur decede selon la valeur du
 * champ Transfusion
 * 
 * @access: public
 * @return: null
 */
function activeDodBandeau(value) {

	if (value == '1') {

		document.getElementById('dod_bandeau').style.display = 'block';

	} else {

		document.getElementById('dod_bandeau').style.display = 'none';
	}
}

/**
 * Methode qui calcule le DFG du donneur decede
 * 
 * @access: public
 * @return: null
 */
function calculeDod_Dfg() {

	var creatine = "";

	var age = "";

	var sexe = "";

	var calcul = 0;
	var idLabel_don_creat_prelev = "";
	var idLabel_don_age = "";

	try {

		if ((document.getElementById('don_creat_prelev').value == null)
				|| (document.getElementById('don_creat_prelev').value == ''))
			return;
		creatine = document.getElementById('don_creat_prelev').value.replace(
				",", ".");

		if ((document.getElementById('don_age').value == null)
				|| (document.getElementById('don_age').value == ''))
			return;
		age = document.getElementById('don_age').value;

		if ((document.getElementById('don_sexe').value == null)
				|| (document.getElementById('don_sexe').value == ''))
			return;
		sexe = document.getElementById('don_sexe').value;

		if (checkNumber(creatine) && (sexe == '1')) {
			calcul = new Number(175 * Math.pow((creatine / 88.4), -1.154)
					* Math.pow(age, -0.203)).toFixed(2);
		}

		if (checkNumber(creatine) && (sexe == '2')) {
			calcul = new Number(175 * Math.pow((creatine / 88.4), -1.154)
					* Math.pow(age, -0.203) * 0.742).toFixed(2);

		}

		if (!isNaN(calcul)) {
			document.getElementById('don_dfg').value = calcul;
		} else {
			idLabel_don_creat_prelev = returnIdLabel(document
					.getElementById('don_creat_prelev'));
			idLabel_don_age = returnIdLabel(document.getElementById('don_age'));

			alert('Une erreur est survenue lors du calcul DFG.\n La valeur des champs cr�atine '
					+ document.getElementById(idLabel_don_creat_arrivee).innerHTML
					+ ' et '
					+ document.getElementById(idLabel_don_age).innerHTML
					+ ' doit �tre positif.');
		}

	} catch (e) {

		alert("Une erreur est survenue lors du calcul de la DFG du donneur d�c�de : "
				+ e.message);

	}
}

/**
 * Methode qui affiche les champs commentaires du protocole et le lien du
 * protocole en fonction de la valeur de ce dernier
 * 
 * @access: public
 * @return: null
 */
function activeCommentlienpro(value) {

	if (value == '1') {

		document.getElementById('gre_comment_protocole').style.display = 'table-cell';
		document.getElementById('lien_protocole').style.display = 'table-cell';

	} else {

		document.getElementById('gre_comment_protocole').style.display = 'none';
		document.getElementById('lien_protocole').style.display = 'none';
	}

}

/**
 * Methode qui permet d'afficher en couleur le risque immuno
 * 
 * @access: public
 * @return: null
 */
function styleRim(element) {
	switch (element.value) {
	case '1':
		element.style.color = '#677E52';
		break;
	case '2':
		element.style.color = '#FF5B2B';
		break;
	case '3':
	case '4':
		element.style.color = '#E70739';
		break;
	default:
		element.style.color = 'none';
	break;
	}

}

/**
 * Methode qui verifie l'heure au format hh:mm
 * 
 * @access: public
 * @return: null
 */
function verifHeure(element) {
	var result = false;
	var idLabel = "";

	result = isHourMinute(element.value, ":");

	if (!result && element.value != '') {
		idLabel = returnIdLabel(element);
		var name = element.name;
		alert('Le format attendu du champ '
				+ document.getElementById(idLabel).innerHTML + ' est hh:mm.');
		// document.getElementById(name).focus();
		setTimeout(function() {
			element.focus();
		}, 10);
	}
}

/**
 * Methode qui retourne l'id d'un label
 * 
 * @access: public
 * @return: chaine
 */
function returnIdLabel(element) {
	var idLabel = "";

	idLabel = 'label_' + element.name;

	return idLabel;
}

/**
 * Methode qui verifie la taille d'un caract�re
 * 
 * @access: public
 * @return: chaine
 */
function verifTaille(element) {
	var idLabel = "";
	var label = "";

	if (element.value != '') {
		idLabel = returnIdLabel(element);
		label = document.getElementById(idLabel).innerHTML;

		if ((label == 'N� CRISTAL') && (element.value.length < 10)) {
			var name = element.name;

			alert('Le champ ' + document.getElementById(idLabel).innerHTML
					+ ' doit �tre cod� sur 10 chiffre.');
			setTimeout(function() {
				element.focus();
			}, 10);
		}
	}

}

/**
 * Methode de compl�tion qui met l'heure au bon format hh:mm
 * 
 * @access: public
 * @return: chaine
 */
function completeTime(element){
	if(element!=null && element.value!='undefined'){
		var timeValue=element.value.replace(/[^0-9]/gi, '');
		if(timeValue.length==0) timeValue='00:00';
		else if(timeValue.length>2){
			timeValue=timeValue.substr(0, 2)+':'+ timeValue.substr(2);
			timeValue=completeMinute(timeValue);
		} else if(timeValue.length==2){
			timeValue=timeValue.substr(0, 2)+':00';
			timeValue=completeMinute(timeValue);
		} else if(timeValue.length<2){
			timeValue='0'+timeValue.substr(0, 1)+':00';
			timeValue=completeMinute(timeValue);
		}
		
		if (isHourMinute(timeValue, ":")){
			element.value=timeValue;
		} else {
			idLabel = returnIdLabel(element);
			var name = element.name;
			alert("La valeur saisie du champ "
					+ document.getElementById(idLabel).innerHTML + " doit �tre sur 24 heures.");
				setTimeout(function() {
				element.focus();
			}, 10);
		}
			
	}
}

/**
 * Methode de compl�tion des minutes au format mm
 * 
 * @access: public
 * @return: chaine
 */
function completeMinute(time){
	var array_time=time.split(':');
	var newTime="";
	var minute=array_time[1];
	if (minute.length<2) {
		newTime=array_time[0]+':'+array_time[1].trim()+'0';
	} else {
		newTime=time;
	}
	return newTime;
}

/**
 * Methode qui vérifie qu'un mot de passe respecte la règle de validation
 * 
 * @param password Mot de passe à verifier
 * @returns true si la chaine est valide, false sinon
 */
function checkPassword(password){
	return /^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).{8,}$/.test(password);
}