/* *
 * $ID overlib_clone.class.js ver: 1.01
 * $Author: Gilbert Rehling - the_isp@hotmail.com
 * Name: OverLIB Clone Mini Class 'Diagnostics' Version
 * Description: Prototype.js based JavaScript OOP Class - JSLINT Verified -
 *  - Clone of Overlib.js found at http://www.bosrup.com/web/overlib/
 * Original Version - Copyright (c) By Erik Bosrup - erik@bosrup.com
 * Copyright (c) 2009 Gilbert Rehling of Creative Imagineering Productions - the_isp@hotmail.com
 * Production Date: 29th May 2009
 * License: MIT Open Source Based License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 * Improvements: Reduced size - less than 2/3rd of original, familiar/similar usage to original,
 *     more verbose usage configuration, completely 'prototype.js' compatible, redundant methods (functions) removed,
 *     automatically adds 'popup' <div> container - no need to declare the HTML on page,
 *     added a feature changer tool to display on page, automatic relative repositioning
 */

/* ADDED FOR JSLINT COMPATABILITY - GLOBAL AND (CLASS) MEMBER PROPERTIES */
/* JSLINT Options */
/*jslint bitwise: true, browser: true, eqeqeq: true, immed: true, newcap: true, nomen: true, regexp: true, undef: true*/

/*global Class, $, $$, $A, $H, Element, window, Info, Layer, Event, type_Of, event, setScrollBox, replace*/

/*members above, aboveheight, add, addcss, added_css, add_style, add_features, appendChild, arguments, autostatus, autostatuscap, background, backgroundb, backgroundColor, backgroundImage, bgcolor, bind, bindAsEventListener, body, border, bottom, capbgcolor, capborder, capbrdcol, capcolor, capicon, capsize, capweight, center, chk_pos, className, clear_sticky, clearingsticky, closeclick, closecolor, closesize, closetext, closetitle, closeweight, color, commands, contHeight, contWidth, create, createElement, createTextNode, cssText, defaultStatus, defstat, diag_value, divborder, divbrdcol, do_cache, docRoot, each, extend, feature_cache, feature_mode, feature_pos, feature_top, fill_cont, fixx, fixy, followmouse, fontFamily, fontSize, fontWeight, getElementsByTagName, getHeight, getScrollOffsets, getWidth, goup, height, hidedelay, html, id, initialize, innerHTML, insert, isleft, ispopup, isup, key, left, length, nd, observe, offsetx, offsety, olLoaded, olc_aboveheight, olc_autostatus, olc_autostatuscap, olc_background, olc_bgcolor, olc_border, olc_bordercol, olc_bordercol, olc_brdbackground, olc_cap, olc_capalign, olc_capbgcolor, olc_capborder, olc_capbrdcol, olc_capclass, olc_capcolor, olc_capfont, olc_capicon, olc_caps, olc_capsize, olc_capweight, olc_class_id, olc_close, olc_closebgcol, olc_closeclass, olc_closeclick, olc_closecolor, olc_closefont, olc_closesize, olc_closetext, olc_closetitle, olc_closevalue, olc_closeweight, olc_cont_class, olc_cont_id, olc_css, olc_cssoff, olc_divborder, olc_feature_id, olc_features, olc_fixx, olc_fixy, olc_followmouse, olc_frame, olc_fullhtml, olc_function, olc_hauto, olc_height, olc_hidedelay, olc_hpos, olc_offsetx, olc_offsety, olc_paddcap, olc_paddtext, olc_padxl, olc_padxr, olc_padyb, olc_padyt, olc_relx, olc_rely, olc_scroll, olc_showdelay, olc_snapx, olc_snapy, olc_status, olc_sticky, olc_text, olc_textalign, olc_textaligndiv, olc_textborder, olc_textbrdcol, olc_textclass, olc_textcolor, olc_textfont, olc_texts, olc_textsize, olc_textweight, olc_timeout, olc_vauto, olc_vpos, olc_width, olc_wrap, olc_x, olc_y, overlib, pad, paddcap, padding, paddtext, pointerX, pointerY, pos_cont, pos_feature, position, px, py, relativex, relativey, scroll, self, set, setStyle, set_feature, set_mouse, set_style, show_cont, show_features, showdelay, showingsticky, snapx, snapy, splice, status, status_handler, sticky, stopObserving, style, styleSheet, tal, textAlign, textalignc, textalignd, textalignt, textborder, textbrdcol, textcolor, textsize, textweight, timeout, timer, top, type, v, v_cache, value, vc, viewport, visibility, width, wrap, zIndex*/

var Overlib = Class.create({    /* Class Object for Overlib Mini for Prototype */
    initialize: function(isvalues) {    /* initialize - accepts a HASH object to set configuration */
        var values, loadCheck, hashed;
        if(type_Of(isvalues) === "object") {
            values = isvalues;
        } else {
            values = {};
        }
        /* Initialize RUNTIME here now - values remain within class */
        /* font color, family, size and weight for TEXT, CAPTION and Close link (cap = caption) */
        this.olc_textcolor = (typeof values.olc_textcolor!=='undefined') ? values.olc_textcolor : "#000000";
        this.olc_capcolor = (typeof values.olc_capcolor!=='undefined') ? values.olc_capcolor : "#ADFF2F";
        this.olc_closecolor = (typeof values.olc_closecolor!=='undefined') ? values.olc_closecolor : "#00BFFF";
        this.olc_textfont = (typeof values.olc_textfont!=='undefined') ? values.olc_textfont : "Verdana,Arial,Helvetica";
        this.olc_capfont =(typeof values.olc_capfont!=='undefined') ? values.olc_capfont : "Verdana,Arial,Helvetica";
        this.olc_closefont = (typeof values.olc_closefont!=='undefined') ? values.olc_closefont : "Verdana,Arial,Helvetica";
        this.olc_textsize = (typeof values.olc_textsize!=='undefined') ? values.olc_textsize : "10";
        this.olc_capsize = (typeof values.olc_capsize!=='undefined') ? values.olc_capsize : "12";
        this.olc_closesize = (typeof values.olc_closesize!=='undefined') ? values.olc_closesize : "10";
        this.olc_textweight = (typeof values.olc_textweight!=='undefined') ? values.olc_textweight : "normal";
        this.olc_capweight = (typeof values.olc_capweight!=='undefined') ? values.olc_capweight : "normal";
        this.olc_closeweight = (typeof values.olc_closeweight!=='undefined') ? values.olc_closeweight : "normal";
        /* width and height settings of popup main box (div) - if height optional scroll value for scrolling text*/
        this.olc_width = (typeof values.olc_width!=='undefined') ? values.olc_width : 220;
        this.olc_height = (typeof values.olc_height!=='undefined') ? values.olc_height : false;
        this.olc_scroll = (typeof values.olc_scroll!=='undefined') ? values.olc_scroll : "auto";
        /* borders - div border - 1 size fits all or (border for caption then border for text */
        this.olc_divborder = (typeof values.olc_divborder!=='undefined') ? values.olc_divborder : false;
        this.olc_border = (typeof values.olc_border!=='undefined') ? values.olc_border : "2px";
        this.olc_capborder = (typeof values.olc_capborder!=='undefined') ? values.olc_capborder : "2px 2px 1px 2px";
        this.olc_textborder=(typeof values.olc_textborder!=='undefined') ? values.olc_textborder : "1px 2px 2px 2px";
        /* border colors - (borderc = div border) - (col = color) (cap = caption) (brd = border) */
        this.olc_bordercol = (typeof values.olc_bordercol!=='undefined') ? values.olc_bordercol : "#CDCDCD";
        this.olc_textbrdcol = (typeof values.olc_textbrdcol!=='undefined') ? values.olc_textbrdcol : "#00008B";
        this.olc_capbrdcol = (typeof values.olc_capbrdcol!=='undefined') ? values.olc_capbrdcol : "#00008B";
        /* background colors (bg = background) - (cap = caption) - CAPTION, main popup div container*/
        this.olc_capbgcolor = (typeof values.olc_capbgcolor!=='undefined') ? values.olc_capbgcolor : "#4B0082";
        this.olc_bgcolor = (typeof values.olc_bgcolor!=='undefined') ? values.olc_bgcolor : "#DCDCDC";
        /* paddings - set individually or (1 size fits all) - (olc_paddtext) used as default */
        this.olc_padxl = (typeof values.olc_padxl!=='undefined') ? values.olc_padxl : 1;
        this.olc_padxr = (typeof values.olc_padxr!=='undefined') ? values.olc_padxr : 1;
        this.olc_padyt = (typeof values.olc_padyt!=='undefined') ? values.olc_padyt : 1;
        this.olc_padyb = (typeof values.olc_padyb!=='undefined') ? values.olc_padyb : 1;
        this.olc_paddtext = (typeof values.olc_paddtext!=='undefined') ? values.olc_paddtext : 2;
        this.olc_paddcap = (typeof values.olc_paddcap!=='undefined') ? values.olc_paddcap : 2;
        /* offset -  determines distance of popup from mouse pointer - left-right and top-bottom */
        this.olc_offsetx = (typeof values.olc_offsetx!=='undefined') ? values.olc_offsetx : 10;
        this.olc_offsety = (typeof values.olc_offsety!=='undefined') ? values.olc_offsety : 10;
        /* container tor TEXT and CAPTION value strings - ICON to add on left side of CAPTION */
        this.olc_text = (typeof values.olc_text!=='undefined') ? values.olc_text : "Default Text";
        this.olc_cap = (typeof values.olc_cap!=='undefined') ? values.olc_cap : false;
        this.olc_capicon = (typeof values.olc_capicon!=='undefined') ? values.olc_capicon : "";
        /* sets popup to (stick to the page) until target or popup is mouseovered or another popup called */
        this.olc_sticky = (typeof values.olc_sticky!=='undefined') ? values.olc_sticky : false;
        /* set the URL for an image to use as the main popup divs` and (brd = border) backgrounds */
        this.olc_background = (typeof values.olc_background!=='undefined') ? values.olc_background : false;
        this.olc_brdbackground = (typeof values.olc_brdbackground!=='undefined') ? values.olc_brdbackground : false;
        /* sets popup to stay present until ((close) link - [added extra]) selected, alt value and title for link */
        this.olc_closeclick = (typeof values.olc_closeclick!=='undefined') ? values.olc_closeclick : false;
        this.olc_close = (typeof values.olc_close!=='undefined') ? values.olc_close : 'Close';
        this.olc_closetext = (typeof values.olc_closetext!=='undefined') ? values.olc_closetext : false;
        this.olc_closetitle =(typeof values.olc_closetitle!=='undefined') ? values.olc_closetitle : 'Click to Close';
        this.olc_closebgcol =(typeof values.olc_closebgcol!=='undefined') ? values.olc_closebgcol : '#CDCDCD';
        /* page default status or specifies to use the popups TEXT or CAPTION as a temp status bar value */
        this.olc_status = (typeof values.olc_status!=='undefined') ? values.olc_status : false;
        this.olc_autostatus = (typeof values.olc_autostatus!=='undefined') ? values.olc_autostatus : false;
        this.olc_autostatuscap = (typeof values.olc_autostatuscap!=='undefined') ? values.olc_autostatuscap : false;
        /* positioning values, 1: to viewport grid, 2: relative (padding) to browser, 3: follow pointer, 4: align */
        this.olc_snapx = (typeof values.olc_snapx!=='undefined') ? values.olc_snapx : false;
        this.olc_snapy = (typeof values.olc_snapy!=='undefined') ? values.snapy : false;
            /* padding for x (left-right) or y (top-bottom) when (olc_hauto or olc_vauto = 'auto') */
        this.olc_relx = (typeof values.olc_relx!=='undefined') ? values.olc_relx : 5;
        this.olc_rely = (typeof values.olc_rely!=='undefined') ? values.olc_rely : 5;
        this.olc_followmouse = (typeof values.olc_followmouse!=='undefined') ? values.olc_followmouse : true;
        this.olc_textaligndiv = (typeof values.olc_textaligndiv!=='undefined') ? values.olc_textaligndiv : 'center';
        this.olc_textalign = (typeof values.olc_textalign!=='undefined') ? values.olc_textalign : 'center';
        this.olc_capalign = (typeof values.olc_capalign!=='undefined') ? values.olc_capalign : 'center';
        /* relative positioning - auto detect left-right or top-bottom for popup position relative to pointer */
        this.olc_hauto = (typeof values.olc_hauto!=='undefined') ? values.olc_hauto : 'auto';
        this.olc_vauto = (typeof values.olc_vauto!=='undefined') ? values.olc_vauto : 'auto';
        /* allow full HTML within the popup TEXT */
        this.olc_fullhtml = (typeof values.olc_fullhtml!=='undefined') ? values.olc_fullhtml : false;        
        /* value which is Added to (olc_vpos) to set vertical position when (above) is called */
        this.olc_aboveheight = (typeof values.olc_aboveheight!=='undefined') ? values.olc_aboveheight : 5;
        /* name of frame window where popup div is - must be JS value (self, parent etc) */
        this.olc_frame = (typeof values.olc_frame!=='undefined') ? values.olc_frame : window.self;
        /* automagically remove popup after this timeout value (ignores standard events) */
        this.olc_timeout = (typeof values.olc_timeout!=='undefined') ? values.olc_timeout : false;
        /* run this fucntion to get value for TEXT to display in popup - can be passed in link */
        this.olc_function = (typeof values.olc_function!=='undefined') ? values.olc_function : false;
        /* time delays for (Showing and Hiding) popups - showdelay creates 'tooltip' version */
        this.olc_showdelay = (typeof values.olc_showdelay!=='undefined') ? values.olc_showdelay : 0;
        this.olc_hidedelay = (typeof values.olc_hidedelay!=='undefined') ? values.olc_hidedelay : 1;
        /* wrap popup with a div to restrict width to alloted value */
        this.olc_wrap = (typeof values.olc_wrap!=='undefined') ? values.olc_wrap : false;
        /* CSS controller, Classes for (popup div, Text, Caption & Close link) (cap = caption)(cont = container) */
        this.olc_cssoff = (typeof values.olc_cssoff!=='undefined') ? values.olc_cssoff : false;
        this.olc_cont_class = (typeof values.olc_cont_class!=='undefined') ? values.olc_cont_class : false;
        this.olc_textclass = (typeof values.olc_textclass!=='undefined') ? values.olc_textclass : false;
        this.olc_capclass = (typeof values.olc_capclass!=='undefined') ? values.olc_capclass : false;
        this.olc_closeclass = (typeof values.olc_closeclass!=='undefined') ? values.olc_closeclass : false;
        
        /* Configuration options below here are only for advanced users - beware using there options */
        /* arrays will accept popup texts, captions here instead of in the html. send via configuration fields */
        this.olc_texts = (typeof values.olc_texts!=='undefined') ? values.olc_texts : false;
        this.olc_caps = (typeof values.olc_caps!=='undefined') ? values.olc_caps : false;

        /* position relative to pointer - left, center, (right = default) and above, (below = default) */
        this.olc_hpos = (typeof values.olc_hpos!=='undefined') ? values.olc_hpos : false; /* horizontal */
        this.olc_vpos = (typeof values.olc_vpos!=='undefined') ? values.olc_vpos : false; /* vertical */
        
        /* !! IMPORTANT ! id value (example - id="overDiv") for main popup (cont=container) ! USE a <div> only ! */
        /* !! This option is entirely OPTIONAL as this script WILL create the Popup Object for you !! */
        this.olc_cont_id = (typeof values.olc_cont_id!=='undefined') ? values.olc_cont_id : 'overDiv';
        /* !! IMPORTANT ! id value given to this Class - ie: var overlib = new Overlib(); enables dynamic calling */
        this.olc_class_id = (typeof values.olc_class_id!=='undefined') ? values.olc_class_id : 'overlib';
        
        /* !! id value (example - id="feature") for features selector container ! USE a <span> or <div> only ! */
        this.olc_feature_id = (typeof values.olc_feature_id!=='undefined') ? values.olc_feature_id : 'feature';
        this.show_features = (typeof values.show_features!=='undefined') ? values.show_features : true;
            /* change to false to Not display the feature selector */
        this.feature_mode = (typeof values.feature_mode!=='undefined') ? values.feature_mode : "float";
            /* positioning mode - (static or float) - float is also dropable (moveable) */
            /* static (feature_mode) is placed directly into a HTML elememt tag (<span> or <div>) */
            /* if you use (float), do NOT create a tag on the page - the code will create required elements */
        this.feature_pos = (typeof values.feature_pos!=='undefined') ? values.feature_pos : 'right';
            /* use (left or right) for (top/bottom left or top/bottom right) for float positioning only */
            /* (right) will be used as a default if show_features is true and _pos id NOT set */
        this.feature_top = (typeof values.feature_top!=='undefined') ? values.feature_top : false;
            /* false = at bottom of page - true = at top of page */
        
        /* !! THIS FEATURE OPTION SHOULD NOT BE ALTERED UNLESS YOU KNOW WHAT YOU ARE DOING !! */
        this.olc_features = ["test","followmouse"];
        this.olc_features = $A(this.olc_features); /* creates a nice prototype extended array element */         
        
        /* !! predefined settings !-! do not change !! don't modify anything below this position !! */
        this.olLoaded = false;
        this.ispopup = false;
        this.timer = false;
        /* Display state variables */
        this.olc_x = 0; this.olc_y = 0;
        this.px = false; this.py = false;
        this.showingsticky = false;
        this.clearingsticky = false;
        this.followmouse = false;
        this.isleft = false;
        this.isup = false;
        /* Our layer */
        this.docRoot = 'document.body';
        this.contHeight = false;
        this.contWidth = false;
        /* CLASS NAME */
        this.className = this.olc_class_id;
        /* storage CACHE for changed config values */
        this.v_cache = $A(); /* stores original values of command line altered configs, replace when popup closes */
        this.vc = "clr";
        this.feature_cache = $A();
        this.added_css = $A();
        /* preset command CACHE - defined here - used to assess command input */
               hashed = { sticky: 'olc_sticky', left: 'olc_hpos', center: 'olc_hpos', above: 'olc_vpos', closeclick: 'olc_closeclick', autostatus: 'olc_autostatus', autostatuscap: 'olc_autostatuscap', offsety: 'olc_offsety', offsetx: 'olc_offsetx', paddtext: 'olc_paddtext', paddcap: 'plc_paddcap', padding: 'padding', showdelay: 'olc_showdelay', hidedelay: 'olc_hidedelay', timeout: 'olc_timeout', capsize: 'olc_capsize', capweight: 'olc_capweight', capcolor: 'olc_capcolor', textsize: 'olc_textsize', textweight: 'olc_textweight', textcolor: 'olc_textcolor', closesize: 'olc_closesize', closeweight: 'olc_closeweight', closecolor: 'olc_closecolor', closetext: 'olc_closetext', closetitle: 'olc_closetitle', bgcolor: 'olc_bgcolor', capbgcolor: 'olc_capbgcolor', capbrdcol: 'olc_capbrdcol', textbrdcol: 'olc_textbrdcol', divbrdcol: 'olc_bordercol', divborder: 'olc_divborder', border: 'olc_border', capborder: 'olc_capborder', textborder: 'olc_textborder', width: 'olc_width', height: 'olc_height', textalignd: 'olc_textaligndiv', textalignc: 'olc_textalignc', textalignt: 'olc_textalignt', snapx: 'olc_snapx', snapy: 'olc_snapy', fixx: 'olc_fixx', fixy: 'olc_fixy', relativex: 'olc_relx', relativey: 'olc_rely', aboveheight: 'olc_aboveheight', background: 'olc_background', capicon: 'olc_capicon', followmouse: 'olc_followmouse' };
        this.commands = $H(hashed); /* creates a nice Extended HASH Element to use */
        
        loadCheck = function() { /* function checks for popup container - creates if !NOT! present */
            if(document.body){ /* musn't run untill <body> present */
                var objRef, id = this.olc_cont_id;
                Event.observe(document, 'mousemove', this.set_mouse.bindAsEventListener(this));
                if(!$(id)) {
                    objRef = document.createElement("div");
                    Element.extend(objRef);
                    document.body.appendChild(objRef);
                    objRef.id = id;
                    $(id).setStyle({
                        position: 'absolute',
                              visibility: 'hidden',
                               zIndex: 100,
                        top: 0,
                        left: 0,
                        border: 0
                    });
                }
                this.olLoaded = 1;
            } else {
                setTimeout(function(){ loadCheck(); }, 100);
            }
            if(this.olc_status) { window.defaultStatus = this.olc_status; }
            setTimeout( function() {if(this.show_features === true) { this.add_features(); }}.bind(this), 1000); 
        }.bind(this);
        setTimeout(function(){ loadCheck(); }, 500);
    },
    do_cache: function(name, value, dir) { /* resets and caches passed values and returns defaults */
        var obj, that = this; // alert(name +' - '+value+' - '+dir); 
        if(dir && dir === 1){ /* adds original value to cache + sets config value */
            obj = $H();
            obj.set(name , this[name]);
            this.v_cache[this.v_cache.length] = obj;
            this[name] = value;
            this.vc = "val";
            return;
        }
        if(dir && dir === 2) { /* remove from cache - resets original config values */
            this.v_cache.each(function(v){
                v.each(function(pair){
                    name = pair.key;
                    value = pair.value;
                    that[name] = value;
                });
            });
            this.v_cache.splice(0,this.v_cache.length); /* clear cache! */
            this.vc = "clr";
        }
    },
    overlib: function() { /* main method to set popup */
        if(this.olLoaded !== 1){ alert("Not Loaded Yet! Plase Wait.."); return; }
        var arg, fl, hv, hvt, name, p, pad, r=false, s, t, tt=false, show, that = this, value, vchk;
        this.px = false; this.py = false; this.isleft = false; this.isup = false;
        if((this.olc_sticky === "sticky" && this.showingsticky === 1) || (this.olc_closeclick === 'closeclick' && this.showingsticky === 1)) { /* used to close (sticky and closeclick) popups if another or same popup is requested */
             this.clearingsticky = true; this.clear_sticky('overlib');
             this.olc_hpos = false; this.olc_vpos = false;
        }
        if(this.ispopup === true) { this.nd(); }
        if(this.timer) { clearTimeout(this.timer); this.timer = false; this.do_cache('','',2); $(this.olc_cont_id).setStyle({ visibility: 'hidden', top: 0, left: 0 }); } /* backup in case multiple showdelays */
        if(arguments.length === 1 && type_Of(arguments[0]) === "string") {
            /* ONE ARG ONLY - MUST BE A 'TEXT' STRING! */
            this.olc_text = arguments[0]; r = true;
        } else if(type_Of(arguments) === "object") {
            if(arguments.length === 2 && arguments[1].length > 11){
                /* NO OPTIONS PASSED - CAPTION AND TEXT ONLY */
                this.olc_cap = arguments[0]; this.olc_text = arguments[1]; r = true;
            } else {
                if(arguments[1].length > 11) { /* caption and text */
                    this.olc_cap = arguments[0]; this.olc_text = arguments[1];
                } else { /* text only */
                    this.olc_text = arguments[0];
                }
                arg = $A(this.overlib.arguments);
                       s = function(){
                    if(that.vc === "clr") {
                        arg.each(function(v, i) {
                            that.commands.each(function(pair) {
                                name = pair.key;
                                value = pair.value;
                                if(name === v) {
                                    if(name === "sticky") {
                                        that.olc_sticky = "sticky";
                                    } else if(name === "left" || name === "center" || name === "above" || name === "closeclick" || name === "autostatus" || name === "autostatusc") {
                                        that.do_cache(value,arg[i],1);       
                                    } else if(name === "padding") {
                                        pad = arg[++i];
                                        that.do_cache('olc_paddcap',pad,1);
                                        that.do_cache('olc_paddtext',pad,1);
                                    } else {
                                        v = arg[++i];
                                        that.do_cache(value,v,1);
                                    }
                                }
                            });
                        });
                        r = true;
                    } else {
                        setTimeout(function(){ s(); }, 2);
                    }

                };
                setTimeout(function(){ s(); }, 2);
            }            
        } else {
            alert("ERROR?? type="+type_Of(arguments)+" length="+arguments.length); /* POSSIBLE ERROR! */
            this.olc_text = "Welcome to IMBI Indie Portal!"; // BACKUP TEXT
        }
        t = function() {
            if(r === true){
                fl = that.fill_cont();
                tt = true;
            } else {
                setTimeout(function(){ t(); }, 1);
            }
        };
        setTimeout(function(){ t(); }, 1);
        hvt = function(){
            if(tt === true){
                hv = that.chk_pos();
            } else {
                setTimeout(function() { hvt(); }, 1);
            }
        };
        setTimeout(function() { hvt(); }, 1);
        vchk = function(){
            /* automagically reset popup position, chk_pos uses (RELY RELX = auto), can be switched off*/
            if(hv === true) {
                p = that.pos_cont();
            } else {
                setTimeout(function() { vchk(); }, 1);
            }
        };
        setTimeout(function() { vchk(); }, 1);
        show = function() {
            if(p === true && hv === true) {
                if(that.olc_showdelay && isFinite(that.olc_showdelay) && !that.olc_timeout && !that.timer) {
                    that.timer = setTimeout(function(){ that.show_cont(); }, that.olc_showdelay*1000);
                } else {
                    if(that.clearingsticky===true){setTimeout(function(){that.show_cont();},50);}else{that.show_cont();}
                }
            } else {
                setTimeout(function() { show(); }, 1);
            }
        };
        setTimeout(function() { show(); }, 1);
    },
    nd: function(time) { /* Clears popups if appropriate */
        if((this.olc_sticky === "sticky" && this.showingsticky === 1) || (this.olc_closeclick === 'closeclick' && this.showingsticky === 1)) { /* if (sticky) don't close popup! */
            return;
        }
        var id = this.olc_cont_id, clean, that = this;
        clean = function() { /* common clear function - only used for clearing stickys from event call */ 
            setTimeout(function(){ $(id).setStyle({ visibility: 'hidden', left: 0, top: 0}); $(id).innerHTML = ''; that.do_cache('','',2); }, that.olc_hidedelay); if(that.olc_timeout) { that.olc_timeout = false; } if(that.timer) { clearTimeout(that.timer); that.timer = false; } that.ispopup = false; };
        
        if(!time) { this.olc_cap = false; this.olc_text = false; this.olc_hpos = false; this.olc_vpos = false; if(this.olc_divborder !== false) { $(id).style.border='none'; } }
        if(this.timer) { clearTimeout(this.timer); this.timer = false; }
        if(this.followmouse === true) { this.followmouse = false; }
        if((this.olc_showdelay && isFinite(this.olc_showdelay)) && !time && !this.olc_timeout && !this.clearingsticky) {
            this.do_cache('olc_hidedelay',0,0); /* override */
            clean();
        } else if((time && isFinite(time)) /* || (this.olc_timeout && isFinite(this.olc_timeout))) */ && !this.clearingsticky) {
            this.do_cache('olc_hidedelay',0,0); /* override */
            time = (time) ? time : this.olc_timeout;
            this.timer = setTimeout(function(){ this.nd(); }.bind(this), time*1000);
        } else {
            if(this.clearingsticky === true){ this.do_cache('olc_hidedelay',0,0); this.clearingsticky = false; }
            clean();
        } /* alert(this.nd.caller.toString()); DIAGNOSTIC USE ONLY! */
        this.status_handler(2);
    },
    clear_sticky: function(v) { /* event listener function for 'sticky, closeclick' types */
        this.olc_sticky = false; this.olc_cap = false; this.olc_text = false; this.olc_hpos = false; this.olc_vpos = false;
        if(this.olc_closeclick === 'closeclick') {
            $('closeClick').stopObserving(); /* id for 'cloceclick' link */
        } else {
            $(this.olc_cont_id).stopObserving();
        }
        if(v !== 'overlib') { this.clearingsticky = true; this.showingsticky = false; this.nd(); } else { this.do_cache('','',2); this.showingsticky = false; this.status_handler(2); this.clearingsticky = false; $(this.olc_cont_id).setStyle({visibility: 'hidden', top: 0, left: 0 }); this.ispopup = false; }
        /* stickys cleared by 'mouseoff' event - otherwise replaced by new 'overlib' call */
    },
    set_mouse: function(event) { /* gets and sets mouse position - Document Event Handler - also for 'mousemove' */
        this.olc_x = Event.pointerX(event);
        this.olc_y = Event.pointerY(event);
        if(this.olc_followmouse === true && this.showingsticky === false && this.followmouse === true && this.clearingsticky === false) {
            var id = this.olc_cont_id, x, y; this.chk_pos();
                   if(this.isleft !== false){ x = this.olc_x - this.isleft; } else{ x = this.olc_x + this.olc_offsetx; }
            if(this.isup !== false) { y = this.olc_y - this.isup; } else { y = this.olc_y + this.olc_offsety; }
            $(id).setStyle({ top: y+'px', left: x+'px' });
        }
    },
    pos_cont: function() { /* position the popup container - used to reset data from this.reset_pos */
        var id = this.olc_cont_id, x, y;
        if(this.olc_hpos) { /* set position (left or center) - ! right is DEFAULT ! */
            if(this.olc_hpos === "center") {
                x = this.olc_x - (this.contWidth/2);
            } else if(this.olc_hpos === "left") {
                x = this.olc_x - (this.olc_offsetx + this.contWidth);
                this.isleft = this.olc_offsetx + this.contWidth;
            }
        } else {
            x = this.olc_x + this.olc_offsetx; /* default */
        }
        /* capture 1st positions for checks! */
        this.py = y = (!this.py) ? this.olc_y : this.py; this.px = (!this.px) ? x : this.px;               
        $(id).setStyle({ left: x+'px', top: y+'px' });
        return true;
    },
    set_style: function(id , prefix) { /* set font styles for Caption & Text - prefix determines config values used */
        $(id).setStyle({
            color: this['olc_'+prefix+'color'],
            fontFamily: this['olc_'+prefix+'font'],
            fontSize: this['olc_'+prefix+'size']+'px',
            fontWeight: this['olc_'+prefix+'weight'],
            textAlign: this['olc_'+prefix+'align']
        }); /* using 'this['olc_'+prefix+'font'] instead of "evil" eval(this.'olc_'+prefix+'font') */
    },
    fill_cont: function() {
        var id = this.olc_cont_id, html, olc_text;
        $(id).setStyle({ width: this.olc_width+'px', backgroundColor: this.olc_bgcolor, textAlign: this.olc_textaligndiv }); /* popup div basic inline style */
        if(this.olc_divborder) { $(id).setStyle({ border: this.olc_divborder+'px ' +this.olc_bordercol+ ' solid' });}
        /* to maintain XHTML validity, we use -n- within popup text instead of <br /> and convert it here to <br />*/
        olc_text = this.olc_text;
        this.olc_text = olc_text.replace(/-n-/gi, "<br />");
        if(this.olc_cap){ /* if caption is set - adds the caption div with id = 'capDiv' */
            html = '<span><div id="capDiv" style="border-width: '+this.olc_capborder+'; border-color: '+this.olc_capbrdcol+'; border-style: solid; padding: '+this.olc_paddcap+'px; background-color: '+this.olc_capbgcolor+';"></div><div id="textDiv" style="border-width: '+this.olc_textborder+'; border-color: '+this.olc_textbrdcol+'; border-style: solid; padding: '+this.olc_paddtext+'px;"></div></span>';
            $(id).innerHTML = html;
            if(this.olc_closeclick === 'closeclick') { /* add click to close link - resets the padding as well */
                this.olc_close = (!this.olc_closetext) ? this.olc_close : this.olc_closetext;
                $('capDiv').innerHTML = '<div id="capLeft" style="float: left; text-align: left; color: '+this.olc_capcolor+'; background-color: '+this.olc_capbgcolor+';">'+this.olc_cap + '</div><div id="closeClick" style="text-align: right; font-family: '+this.olc_closefont+'; font-size: '+this.olc_closesize+'; font-weight: '+this.olc_closeweight+'; cursor: pointer; background-color: '+this.olc_closebgcol+';" title="'+this.olc_closetitle+'">'+this.olc_close+'</div>';
                $('capDiv').setStyle({ padding: 0 }); $('capLeft').setStyle({ padding: this.olc_paddcap }); $('closeClick').setStyle({ padding: this.olc_paddcap }); /* reset the padding values for (capDiv)(capLeft)(closeClick) div */
            } else { /* default */
                $('capDiv').innerHTML = this.olc_cap;
            }
            $('textDiv').innerHTML = this.olc_text;
            this.set_style('capDiv','cap'); this.set_style('textDiv','text');
        } else { /* no caption - only text */
            html = '<span><div id="textDiv" style="border: '+this.olc_border+' '+this.olc_textbrdcol+' solid; padding: '+this.olc_paddtext+'px;"></div></span>';
            $(id).innerHTML = html;
            $('textDiv').innerHTML = this.olc_text; this.set_style('textDiv','text');
        }
        if(this.olc_background){ $('textDiv').setStyle({ backgroundImage: 'url('+this.olc_background+')' }); }
        return true;
    },
      show_cont: function() { /* populate and show container - configure above view id set */
         var id = this.olc_cont_id;
        $(id).setStyle({ visibility: 'visible' }); this.ispopup = true;        
        if(this.olc_sticky === "sticky") { /* if sticky - attach event listener to popup div object */
            Event.observe(this.olc_cont_id, 'mouseout', this.clear_sticky.bindAsEventListener(this));
            this.showingsticky = 1;
        }
        if(this.olc_timeout && isFinite(this.olc_timeout)) { /* creates tooltip while mouse still hovers */
            this.olc_hidedelay = 1;
            this.timer = setTimeout(function(){ this.nd(); }.bind(this), this.olc_timeout*1000);
            /* command value is in seconds - so we need to multiply by 1000 for milliseconds */
        }
        if(this.olc_followmouse === true && !this.showingsticky){ /* default setting - follows pointer */
            this.followmouse = true;
        }
        if(this.olc_closeclick === 'closeclick') {
            Event.observe('closeClick', 'click', this.clear_sticky.bindAsEventListener(this));
            this.showingsticky = 1;
            this.add_style('#closeClick', 'color: #0000FF;');
            this.add_style('#closeClick:hover', 'color: #FF0000;');
        }
        this.status_handler(1);
    },
    add_style: function() { /* adds a style into the head section for 'overlib-clone' */
        var headElement = document.getElementsByTagName("head")[0], styleElement = document.createElement("style"), selector, rule, addcss = " ";    // headElement = document.getElementsByTagName("head")[0], $$('head')
    //    var headElement = document.select('head'), styleElement = document.createElement("style"), selector, rule;
        
        selector = arguments[0]; rule = arguments[1];
        this.added_css.push(selector + " { " + rule + " }");

        if(!$('overlib-clone')) { /* runs if <style> tag with id NOT created yet */
            styleElement.id = "overlib-clone";
            styleElement.setAttribute = "text/css";
            headElement.appendChild(styleElement);
            if(styleElement.styleSheet) { // IE
                styleElement.styleSheet.cssText = selector + " { " + rule + " }";
            } else {
                Element.insert(styleElement, { 'top': selector + " { " + rule + " }" });
            }            
        } else {
            styleElement = $("overlib-clone");
            if(styleElement.styleSheet) {
                this.added_css.each(function(css){ 
                        addcss = addcss + css;
                        }
                );
                styleElement.styleSheet.cssText = addcss;
            } else {
                Element.insert(styleElement, { 'bottom': selector + " { " + rule + " }" });
            }
        }        
    },
    chk_pos: function(dir) { /* used to check popup's defined position within browser window */
        var id = this.olc_cont_id, scroll, vph, vpw, y;
        this.contHeight = $(id).getHeight(); this.contWidth = $(id).getWidth(); /* container sizes */
        vph = document.viewport.getHeight(); /* gets browser height - in case popup is too low/high in page */
        vpw = document.viewport.getWidth(); /* gets browser window width - in case popup is too close to sides */
        scroll = document.viewport.getScrollOffsets(); /* if page scrolled - adds to vph for bottom of page check */
        /* check verticals */
        if(this.olc_vpos === "above" && !this.ispopup) { /* check clearance above popup */
             if((this.olc_y - (this.olc_offsety + this.contHeight) < (0 + this.olc_rely)) && this.olc_vauto === "auto") {
                this.olc_y = this.olc_y + this.olc_offsety; /* godown - default - no need to modify */
            } else {
                y = this.olc_offsety + this.contHeight + this.olc_aboveheight;
                this.py = this.olc_y - y; /* going up */
                this.isup = y;
            }
        } else if(!(this.ispopup)) { /* default is below */
            if((this.olc_y + this.olc_offsety + this.contHeight > ((vph - this.olc_rely) + scroll.top)) && this.olc_vauto === "auto") {
                y = this.olc_offsety + this.contHeight + this.olc_aboveheight;
                this.py = this.olc_y - y; /* redirected to go above */
                this.isup = y;
            } else {
                this.olc_y = this.olc_y + this.olc_offsety; /* goimg down */
            }
        }
        /* check horozontals */
        if(this.olc_hpos === "left") {
            if(((this.olc_x - (this.olc_offsetx + this.contWidth)) <= (0 + this.olc_relx)) && this.olc_hauto === "auto") {
                /* check left clearance */ 
                this.olc_hpos = false; this.isleft=false; /* swap sides! */
            }
        } else if(this.olc_hpos === "center") {
            if(((this.olc_x + this.olc_offsetx + this.contWidth) > (vpw - this.olc_relx)) && this.olc_hauto === "auto"){
                /* check right clearance*/
                this.olc_hpos = "left"; /* swap sides! */
                this.isleft = this.olc_offsetx + this.contWidth;
            } else if(((this.olc_x - (this.olc_offsetx + this.contWidth)) <= (0 + this.olc_relx)) && this.olc_hauto === "auto") {
                /* check left clearance */
                this.olc_hpos = false; /* swap sides! */
            }
        } else { /* default is right! */
            if(((this.olc_x + this.olc_offsetx + this.contWidth) > (vpw - this.olc_relx)) && this.olc_hauto === "auto") {
                /*check right clearance*/
                this.olc_hpos = "left"; /* swap sides! */
                this.isleft = this.olc_offsetx + this.contWidth;
            }
        }
        return true;
    },
    status_handler: function(dir) { /* handles the various 'window status' values if any are configured */
        this.defstat = (this.olc_status) ? this.olc_status : "Thanks for using OverLIB Clone Mini Prototype Class";
        if(dir === 1) { /* setting popup */
            if(this.olc_autostatus && !this.olc_autostatuscap) {
                window.status = this.olc_text;
            } else if(this.autostatuscap) {
                window.status = this.olc_cap;
            }
        } else if(dir === 2) { /* removing popup */
            if(this.defstat) {
                window.defaultStatus = this.defstat;
            }
        }
    },
    add_features: function() {
        var id = this.olc_feature_id, height, html, tal, y, vph;
        html = '<select id="features" name="features" size="1" onchange="'+this.className+'.set_feature(this.value); this.options[0].selected=\'selected\';"><option value=\'\'>Select or Switch A Feature Here</option><optgroup label="Enable or Disable a Feature">';
        this.olc_features.each(function(v) {
            html = html + '<option value="'+v+'">'+v+'</option>';
        });
        html = html + '</optgroup></select>';
        if(this.feature_mode === "static" && $(id)) { /* feature container must be predefined on page*/
            $(id).innerHTML = html;
        } else if(this.feature_mode === "float") {
            /* wrap the current HTML container (if it exists) and position */
            if($(id)) {
                $(id).wrap('div', { 'id': 'feature-wrapper' });
            } else {
                Element.insert(document.body, {'bottom': '<div id="feature-wrapper"><span id="'+id+'"></span></div>'});
            }
            $(id).innerHTML = html;
            tal = (this.feature_pos) ? this.feature_pos : "right"; /* text align setting */
            if(this.feature_top === false) {
                vph = document.viewport.getHeight(); height = $('feature-wrapper').getHeight();
                y = vph - (height + 8);
            } else { y = 0; }
            this.add_style('#feature-wrapper', 'position: absolute; left: 0; top: '+y+'px; z-index: 10; width: 99%; text-align: '+tal+'; padding: 5px;');
            this.add_style('#'+id, 'position: relative; padding: 5px; background-color: #191970; opacity: 0.6; filter: alpha(opacity=60)');
            Event.observe(window, 'scroll', this.pos_feature.bindAsEventListener(this));
        }
    },
    pos_feature: function() {
        var pos = document.viewport.getScrollOffsets(), y;
        y = (this.feature_top === true) ? pos.top : ((pos.top + document.viewport.getHeight()) - $('feature-wrapper').getHeight());
        $('feature-wrapper').setStyle({ top: y+'px' });
    },
    set_feature: function(val) {
        if(val === "followmouse") {
            this.feature_cache[this.feature_cache.length] = this.olc_followmouse;
            this.olc_followmouse = (this.olc_followmouse) ? false : true;
        }
    }
});