var PageBrowser = Class.create();
PageBrowser.prototype = {
	initialize: function(opt) {
		this.id = opt.id;
		this.wrapper = opt.cont;
		this.pages = opt.no;
		this.page = 1;
		this.zoom_step = 0;
		this.pb = [];
		
		this.wait = 0;

		$(this.wrapper).observe('scroll', this.onscroll.bindAsEventListener(this));
	},
	
	// browse through pages (previous | next buttons)
	browse: function(inc) {
		if (this.wait || this.page + inc == 0 || this.page + inc > this.pages) return;
		
		this.focusPage(this.page + inc);
	},
	
	// update page # when scrolling container
	onscroll: function() {
		if (this.wait) return;
		
		var offset = $(this.wrapper).scrollTop + ($(this.wrapper).getHeight() / 2);
		for (var i = 1; i <= this.pb.length; i++)
			if (offset <= this.pb[i])
				break;
		
		//alert(offset);
		//if (location.href.indexOf('#p' + i) == -1) {
			//location.href = '#p' + i;
			//this.page = i;
		//}
	},
	
	// bring a page into view
	focusPage: function(page) {
		this.do_scroll = 0;
		
		var offset = 0;
		for (var i = 1; i <= page - 1; i++)
			offset += $(this.wrapper + i).getHeight();
		offset += (page - 1) * 245;
		$(this.wrapper).scrollTop = offset;
		
		this.page = page;
		location.href = '#p' + this.page;
		
		this.do_scroll = 1;
	}

}