// JavaScript Document

/**
 * Open popup 
 * 
 * @parameter: url = URL
 * @parameter: w = width
 * @parameter: h = height
 * @parameter: popupName = ame of popup
 * @parameter: scrollbars (default is 0 - without scroll)
 * @access: public
 * @return: null
 * @author: CFlorin (colotin_f@yahoo.com)
 * @date: 02.02.2005 (dd.mm.YYYY)
*/ 
function popup(url, w, h, popupName, scrollbars)
{
	if(popupName == '') popupName='popup';
	if(scrollbars == '') scrollbars=0;
	if(w==0) w=(screen.width);
	if(h==0) h=(screen.height);
	options='menubar=no, scrollbars='+scrollbars+', statusbar=no, resizable=no, toolbar=no, location=no, status=no';
	var top=(screen.height-h)/2-18;
	var left=(screen.width-w)/2-8;
	return window.open(url, popupName, 'top='+top+', left='+left+', width='+w+', height='+h+', '+options);
}

function objShowHide(objName, keepPosition)
{
	var elem=findDOM(objName, 1);
	
	if(elem.visibility=='hidden') 
	{ 
		elem.visibility='visible';
		if(keepPosition!=1)
			elem.position='relative'; 
	} 
	else 
	{ 
		elem.visibility='hidden'; 
		if(keepPosition!=1)
			elem.position='absolute'; 
	} 
}

// inner write
function innerWrite(objName, text)
{
	var elem = findDOM(objName, 0);
	elem.innerHTML = text;
}

// inner write
function imgSrcChange(objName, src)
{
	var elem = findDOM(objName, 0);
	elem.src = src;
}

function switchMultipleCheckBox(objForm, textMatch)
{	
	var items = objForm.elements;	
	for(i=0; i < items.length; i++)
	{
		if(items[i].name.match(textMatch))
		{
			if(items[i].checked==true)
				items[i].checked = false;
			else if(items[i].disabled==false)
				items[i].checked = true;
		}
	}
}

/**
* Count chars from a textarea
*
* @author Colotin Florin
*/
function countInputChars(objText, objCounter, limit)
{
	if (objText.value.length > limit)
		objText.value = objText.value.substr(0,limit);
	objCounter.value=objText.value.length;
}


var openedWin = 0;
var offsetHeight = 0;
function openWin(obj, url) {
	if (!openedWin) {
		applyStyle(obj, 'src', url, 0);
		applyStyle(obj, 'visibility', 'visible', 1);
		openedWin = 1;
		offsetHeight = 83;
	}
}

function ifrClose(objWin)
{	
	window.parent.openedWin    = 0;
	window.parent.offsetHeight = 0;
	applyStyleParent(objWin, 'visibility', 'hidden', 1);
	applyStyleParent(objWin, 'src', '', 0);
}



function objColorBlink(objName, classBlink)
{
	var obj = findDOM(objName, 0);
	if(obj.className!=classBlink)
	{
		obj.className=classBlink;
	}
	else
	{
		obj.className='';
	}
}

function setAlpha(id, opacity) {
	element = findDOM(id, 0);
	if (typeof(element.filters) == 'object')
	{
		element.filters.alpha.opacity = opacity;
	}
	else if (element.style.setProperty)
	{
		element.style.setProperty('-moz-opacity', opacity / 100, '');
	}
}

function addBookmark(url, title) {
	if (browser == 'ie') 
		window.external.AddFavorite(url, title);
	else
		window.sidebar.addPanel(title, url, ""); 
}

function captureEvent(evt, keyCode, snippet) {
	e = (evt) ? evt : (window.event) ? event : null;

	if (e.keyCode) 
		code = e.keyCode;
	else
		if (e.which) 
			code = e.which;

	if (code == keyCode) 
		eval(snippet);
}

function returnEvent(evt) {
	e = (evt) ? evt : (window.event) ? event : null;

	if (e.keyCode) 
		code = e.keyCode;
	else
		if (e.which) 
			code = e.which;

	return code;
}

function MM_preloadImages() { //v3.0
  	var d=document; 
	if (d.images) { 
		if(!d.MM_p) 
			d.MM_p=new Array();
    	var i,j=d.MM_p.length,a=MM_preloadImages.arguments; 
		for(i=0; i<a.length; i++)
    		if (a[i].indexOf("#")!=0) { 
				d.MM_p[j]=new Image; 
				d.MM_p[j++].src=a[i];
			}
	}
}

/*
function fSort(field_sort, list_param)
{
	var url=searchLink+'&field_sort='+field_sort;
	if(typeof list_param !='undefined' && list_param!='')
		url=url+list_param;
	
	window.location=url;
}
*/


/**
 * Sort after table column (db)
 * 
 * @parameter: field to sort and list of parameters
 * @author: CFlorin (colotin_f@yahoo.com) - www.yourchoice.ro
 * @date: 29.02.2008 (dd.mm.YYYY)
*/
function fSort(field_sort, list_param)
{	
	var location=(window.location)+'';
	
	var tmpArr=location.split('?');
	tmpArr=tmpArr[1].split('#');
	tmpArr=tmpArr[0].split('&');
		
	var url='';
	for(i=0;i<tmpArr.length;i++)
	{
		p1=tmpArr[i].search(/obj/i);
		p2=tmpArr[i].search(/action/i);
		
		if(p1>=0 || p2>=0)
			url+=tmpArr[i]+'&'		
	}
	if(url!='')
	{
		var file='';
		if(FILE_SELF=='admin.php')
			file=ROOT_HOST+'admin/'+FILE_SELF;
		else
			file=ROOT_HOST+FILE_SELF;
		url=file+'?'+url.substr(0, url.length-1)+'&field_sort='+field_sort;
		
		if(typeof list_param !='undefined' && list_param!='')
			url=url+list_param;
		
		window.location=url;
	}
		
	return false;		
}

function setWaitPage(wait)
{
	if (wait)
		$('page').setOpacity(0.5);
	else
		$('page').setOpacity(1);
}

/* This tooltip library was created by Mukul Kumar; http://codeeazy.com */
function showtip(e,message){var x=0;var y=0;var m;var h;if(!e)
var e=window.event;if(e.pageX||e.pageY){x=e.pageX;y=e.pageY;}
else if(e.clientX||e.clientY){x=e.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;y=e.clientY+document.body.scrollTop+document.documentElement.scrollTop;}
m=document.getElementById('mktipmsg');if((y>10)&&(y<450)){m.style.top=y-4+"px";}
else{m.style.top=y+4+"px";}
var messageHeigth=(message.length/20)*10+25;if((e.clientY+messageHeigth)>510)
{m.style.top=y-messageHeigth+"px";}
if(x<850){m.style.left=x+20+"px";}
else{m.style.left=x-170+"px";}
m.innerHTML=message;m.style.display="block";m.style.zIndex=203;}
function hidetip(){var m;m=document.getElementById('mktipmsg');m.style.display="none";}
